/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath;

import com.werken.xpath.ContextSupport;
import com.werken.xpath.DefaultVariableContext;
import com.werken.xpath.ElementNamespaceContext;
import com.werken.xpath.XPath;
import com.werken.xpath.XPathFunctionContext;
import java.io.File;
import java.util.List;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Test {
    public static void main(String[] args) {
        System.out.println("werken xpath -- test driver\n");
        if (args.length != 2) {
            System.err.println("Usage: java ...TestDriver <input file> <xpath_expr>");
            System.exit(1);
        }
        SAXBuilder builder = new SAXBuilder();
        File inFile = new File(args[0]);
        String xpathExpr = args[1];
        try {
            Document doc = builder.build(inFile);
            XPath xpath = new XPath(xpathExpr);
            System.err.println("XPath :: " + xpath.getString());
            ContextSupport contextSupport = new ContextSupport();
            DefaultVariableContext vc = new DefaultVariableContext();
            vc.setVariableValue("foo", "cheese burgers");
            System.err.println("Context :: " + doc);
            ElementNamespaceContext nc = new ElementNamespaceContext(doc.getRootElement());
            contextSupport.setFunctionContext(XPathFunctionContext.getInstance());
            contextSupport.setVariableContext(vc);
            contextSupport.setNamespaceContext(nc);
            List results = xpath.applyTo(contextSupport, doc);
            System.err.println("Results :: " + results);
        }
        catch (JDOMException jde) {
            jde.printStackTrace(System.err);
        }
    }
}

