/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.targets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.jboss.ant.targets.DynamicTarget;
import org.jboss.ant.types.build.Build;
import org.jboss.ant.types.component.ComponentDefinition;

public class ShowTarget
extends DynamicTarget {
    public ShowTarget(Build build) {
        super(build, "show", "Show the targets");
    }

    public ShowTarget(ComponentDefinition componentDef) {
        super(componentDef, "show", "Show the targets");
    }

    public void execute() {
        Project project = this.getProject();
        Hashtable targets = project.getTargets();
        String showProperty = project.getProperty("show");
        ArrayList names = new ArrayList(targets.keySet());
        Collections.sort(names);
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (showProperty != null && !name.startsWith(showProperty)) continue;
            Target target = (Target)targets.get(name);
            this.showTarget(target);
        }
    }

    public void showTarget(Target target) {
        if (target instanceof DynamicTarget) {
            String description = target.getDescription();
            if (description != null) {
                System.out.println("<!-- " + description + " -->");
            }
            System.out.print("<target name=\"" + target.getName() + "\"");
            Enumeration depends = target.getDependencies();
            if (depends.hasMoreElements()) {
                System.out.print(" depends=\"");
                while (depends.hasMoreElements()) {
                    System.out.print(depends.nextElement());
                    if (!depends.hasMoreElements()) continue;
                    System.out.print(", ");
                }
                System.out.print("\"");
            }
            System.out.print(">");
            ((DynamicTarget)target).show();
            System.out.println("\n</target>\n");
        }
    }
}

