/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.targets;

import java.util.Vector;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.jboss.ant.targets.DynamicTargetException;
import org.jboss.ant.types.AbstractBuildDataType;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.util.LoggerUtil;
import org.jboss.ant.util.MacroUtil;

public abstract class DynamicTarget
extends Target {
    protected LoggerUtil.Logger log;
    private AbstractBuildDataType dataType;
    private boolean generated = false;

    public DynamicTarget(AbstractBuildDataType dataType, String name, String description) {
        this.dataType = dataType;
        this.log = new LoggerUtil.Logger((ProjectComponent)dataType, (Object)this);
        this.setName(name);
        if (description != null) {
            this.setDescription(description);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("New target: " + name);
        }
    }

    public void execute() {
        if (!this.generated) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Generating target '" + this.getName() + "' ...");
            }
            this.dataType.validate();
            this.generate();
            this.generated = true;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Executing target '" + this.getName() + "' ...");
            }
            super.execute();
        }
        catch (Exception e) {
            DynamicTargetException.rethrow(this.dataType.toShortString(), this.getName(), e);
        }
    }

    public void show() {
        System.out.print("\n<!-- Dynamic Target -->");
    }

    protected AbstractBuildDataType getDataType() {
        return this.dataType;
    }

    protected void generate() {
    }

    protected void addTask(RuntimeConfigurable rc) {
        UnknownElement element = (UnknownElement)rc.getProxy();
        super.addTask((Task)element);
        if (this.log.isTraceEnabled()) {
            this.log.trace("... added macro: " + MacroUtil.dumpMacro(element));
        }
    }

    protected void generateTasks(DynamicType dynamicType) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("generateTasks: " + dynamicType.getId());
        }
        Vector taskDefinitions = dynamicType.getElements();
        int i = 0;
        while (i < taskDefinitions.size()) {
            DynamicType taskDefinition = (DynamicType)((Object)taskDefinitions.get(i));
            RuntimeConfigurable rc = this.createMacro(taskDefinition.getId());
            MacroUtil.configure(rc, taskDefinition, (Object)this.dataType, this.getProject(), this);
            this.addTask(rc);
            ++i;
        }
    }

    protected RuntimeConfigurable createMacro(String name) {
        return MacroUtil.createMacro(name, this.getProject(), this);
    }
}

