/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.swing.table.TableModel;
import org.apache.commons.logging.LogFactory;
import webwork.util.BeanUtil;
import webwork.view.taglib.ui.ComponentTag;
import webwork.view.taglib.ui.table.SortFilterModel;
import webwork.view.taglib.ui.table.SortableTableModel;
import webwork.view.taglib.ui.table.WebTableColumn;
import webwork.view.taglib.ui.table.renderer.CellRenderer;

public class WebTable
extends ComponentTag {
    protected String _modelName = null;
    protected WebTableColumn[] _columns = null;
    protected TableModel _model = null;
    int _curRow = 0;
    protected boolean _sortable = false;
    protected int _sortColumn = -1;
    protected String _sortOrder = "NONE";

    public WebTable() {
        this.setTemplate("table.jsp");
    }

    public WebTable(TableModel model) {
        this.setModel(model);
    }

    public void setSortColumn(int sortColumn) {
        this._sortColumn = sortColumn;
    }

    public int getSortColumn() {
        if (this._model instanceof SortableTableModel) {
            return ((SortableTableModel)this._model).getSortedColumnNumber();
        }
        return -1;
    }

    public void setSortOrder(String sortOrder) {
        this._sortOrder = sortOrder.equals("NONE") ? "NONE" : (sortOrder.equals("DESC") ? "DESC" : (sortOrder.equals("ASC") ? "ASC" : "NONE"));
    }

    public String getSortOrder() {
        if (this._model instanceof SortableTableModel && this.getSortColumn() >= 0) {
            return ((SortableTableModel)this._model).getSortedDirection(this.getSortColumn());
        }
        return "NONE";
    }

    public boolean isSortable() {
        return this._sortable;
    }

    public void setSortable(boolean sortable) {
        this._sortable = sortable;
        if (this._sortable && this._model != null && !(this._model instanceof SortableTableModel)) {
            this._model = new SortFilterModel(this._model);
        }
    }

    public String getModelName() {
        return this._modelName;
    }

    public void addParameter(String name, Object value) {
        BeanUtil.setProperty(name, value, this);
        super.addParameter(name, value);
    }

    public void setModelName(String modelName) {
        this._modelName = (String)this.findValue(modelName);
        Object obj = this.findValue(this._modelName);
        if (obj instanceof TableModel) {
            this.setModel((TableModel)obj);
        }
    }

    public void setModel(TableModel model) {
        this._model = model;
        this._columns = new WebTableColumn[this._model.getColumnCount()];
        int i = 0;
        while (i < this._columns.length) {
            this._columns[i] = new WebTableColumn(this._model.getColumnName(i), i);
            ++i;
        }
        if (this._sortable && !(this._model instanceof SortableTableModel)) {
            this._model = new SortFilterModel(this._model);
        }
    }

    public TableModel getModel() {
        return this._model;
    }

    public int getColumnCount() {
        return this._columns.length;
    }

    public WebTableColumn getColumn(int index) {
        try {
            return this._columns[index];
        }
        catch (Exception E) {
            return null;
        }
    }

    public WebTableColumn[] getColumns() {
        return this._columns;
    }

    public int getRowCount() {
        return this._model.getRowCount();
    }

    public String[] getFormattedRow(int row) {
        ArrayList<String> data = new ArrayList<String>(this.getNumberOfVisibleColumns());
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this._columns[i].isVisible()) {
                data.add(this._columns[i].getRenderer().renderCell(this, this._model.getValueAt(row, i), row, i));
            }
            ++i;
        }
        return data.toArray(new String[0]);
    }

    public Object[] getRow(int row) {
        ArrayList<Object> data = new ArrayList<Object>(this.getNumberOfVisibleColumns());
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this._columns[i].isVisible()) {
                data.add(this._model.getValueAt(row, i));
            }
            ++i;
        }
        return data.toArray(new Object[0]);
    }

    public Object getRawData(int row, int column) {
        return this._model.getValueAt(row, column);
    }

    public Iterator getRowIterator() {
        return new WebTableRowIterator(this);
    }

    public Iterator getRawDataRowIterator() {
        return new WebTableRowIterator(this, 1);
    }

    public void setColumnHidden(int column, boolean hide) {
        this._columns[column].setHidden(hide);
    }

    public boolean isColumnHidden(int column) {
        return this._columns[column].isHidden();
    }

    public void setColumnDisplayName(int column, String displayName) {
        this._columns[column].setDisplayName(displayName);
    }

    public void getColumnDisplayName(int column) {
        this._columns[column].getDisplayName();
    }

    public void setColumnRenderer(int column, CellRenderer renderer) {
        this._columns[column].setRenderer(renderer);
    }

    public CellRenderer getColumnRenderer(int column) {
        return this._columns[column].getRenderer();
    }

    protected int getNumberOfVisibleColumns() {
        int count = 0;
        int i = 0;
        while (i < this._columns.length) {
            if (!this._columns[i].isHidden()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String getSortColumnLinkName() {
        return "WEBTABLE_" + this._modelName + "_SORT_COLUMN";
    }

    public String getSortOrderLinkName() {
        return "WEBTABLE_" + this._modelName + "_SORT_ORDER";
    }

    public int doEndTag() throws JspException {
        block11: {
            if (this._sortable && this._model instanceof SortableTableModel) {
                LogFactory.getLog(this.getClass()).debug((Object)("we are looking for " + this.getSortColumnLinkName()));
                String sortColumn = this.pageContext.getRequest().getParameter(this.getSortColumnLinkName());
                String sortOrder = this.pageContext.getRequest().getParameter(this.getSortOrderLinkName());
                try {
                    if (sortColumn != null || sortOrder != null) {
                        if (sortColumn != null) {
                            try {
                                this._sortColumn = Integer.parseInt(sortColumn);
                            }
                            catch (Exception ex) {
                                LogFactory.getLog(this.getClass()).debug((Object)"coudn't convert column, take default");
                            }
                        }
                        if (sortOrder != null) {
                            this._sortOrder = sortOrder;
                        }
                    } else {
                        LogFactory.getLog(this.getClass()).debug((Object)"no sorting info in the request");
                    }
                    if (this._sortColumn < 0) break block11;
                    LogFactory.getLog(this.getClass()).debug((Object)("we have the sortColumn " + Integer.toString(this._sortColumn)));
                    LogFactory.getLog(this.getClass()).debug((Object)("we have the sortOrder " + this._sortOrder));
                    try {
                        ((SortableTableModel)this._model).sort(this._sortColumn, this._sortOrder);
                    }
                    catch (Exception ex) {
                        LogFactory.getLog(this.getClass()).debug((Object)"couldn't sort the data");
                    }
                    LogFactory.getLog(this.getClass()).debug((Object)"we just sorted the data");
                }
                catch (Exception e) {
                    LogFactory.getLog(this.getClass()).error((Object)e);
                    throw new JspTagException("Error with WebTable: " + this.toString(e));
                }
            }
        }
        return super.doEndTag();
    }

    public class WebTableRowIterator
    implements Iterator {
        protected WebTable _table;
        protected int _curRow = 0;
        protected int _mode = 0;
        public static final int FORMATTED_DATA = 0;
        public static final int RAW_DATA = 1;

        protected WebTableRowIterator(WebTable table) {
            this(table, 0);
        }

        protected WebTableRowIterator(WebTable table, int mode) {
            this._table = table;
            this._mode = mode;
        }

        public boolean hasNext() {
            if (this._table == null) {
                return false;
            }
            return this._table.getRowCount() > this._curRow;
        }

        public Object next() throws NoSuchElementException {
            if (this._table == null) {
                throw new NoSuchElementException("WebTable is null");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("Beyond end of WebTable");
            }
            if (this._mode == 1) {
                return this._table.getRow(this._curRow++);
            }
            return this._table.getFormattedRow(this._curRow++);
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException("Remove not supported in WebTable");
        }
    }
}

