/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import org.jboss.aop.classpool.AOPClassPool;

public abstract class OptimizedInvocations {
    static final String STANDARD_INTERCEPTOR_CODE = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)      {         throw t;       }      finally      {         currentInterceptor--;       }   } ";

    public static void defrostClassIfExists(AOPClassPool pool, String className) {
        try {
            CtClass existing = pool.get(className);
            existing.defrost();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public static CtClass makeInvocationClass(AOPClassPool pool, boolean makeInnerClass, CtClass outerClass, String className, CtClass superInvocation) throws CannotCompileException, NotFoundException {
        CtClass invocation;
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            OptimizedInvocations.defrostClassIfExists(pool, outerClass.getName() + "$" + innerClassName);
            boolean classStatic = true;
            invocation = outerClass.makeNestedClass(innerClassName, classStatic);
            invocation.setSuperclass(superInvocation);
        } else {
            OptimizedInvocations.defrostClassIfExists(pool, className);
            invocation = pool.makeClass(className, superInvocation);
        }
        invocation.addInterface(untransformable);
        CtConstructor[] cons = superInvocation.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            CtConstructor conTemplate = superInvocation.getDeclaredConstructors()[i];
            CtConstructor icon = CtNewConstructor.make((CtClass[])conTemplate.getParameterTypes(), (CtClass[])conTemplate.getExceptionTypes(), (CtClass)invocation);
            invocation.addConstructor(icon);
        }
        return invocation;
    }
}

