/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import javassist.CtMember;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.pointcut.Pointcut;

public class JoinpointSimpleClassifier
extends JoinpointClassifier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JoinpointClassification classifyJoinpoint(CtMember member, Advisor advisor, JoinpointClassifier.Matcher joinpointMatcher) throws NotFoundException {
        Collection pointcuts;
        Collection collection = pointcuts = advisor.getManager().getPointcuts().values();
        synchronized (collection) {
            for (Pointcut pointcut : pointcuts) {
                if (!joinpointMatcher.matches(pointcut, advisor, member)) continue;
                if (AspectManager.verbose) {
                    System.out.println("[debug] " + member + " matches pointcut: " + pointcut.getExpr());
                }
                return JoinpointClassification.WRAPPED;
            }
        }
        if (AspectManager.verbose) {
            System.out.println("[debug] " + member + " matches no pointcuts");
        }
        return JoinpointClassification.NOT_INSTRUMENTED;
    }

    private JoinpointClassification handleError(RuntimeException e, CtMember member) {
        if (AspectManager.suppressTransformationErrors) {
            NotFoundException nfe = null;
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof NotFoundException)) continue;
                nfe = (NotFoundException)cause;
                break;
            }
            if (nfe != null) {
                System.err.println("The member " + member.getName() + " in " + member.getDeclaringClass().getName() + " uses the type " + nfe.getMessage() + " which cannot be found on the classpath. Weaving is therefore skipped for this particular member");
                if (AspectManager.verbose) {
                    e.printStackTrace();
                }
                return JoinpointClassification.NOT_INSTRUMENTED;
            }
        }
        throw e;
    }
}

