/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.PassivationInterceptorMBean;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.blocks.MethodCall;

public class PassivationInterceptor
extends Interceptor
implements PassivationInterceptorMBean {
    protected CacheLoader loader = null;
    private SynchronizedLong m_passivations = new SynchronizedLong(0L);

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m;
        block8: {
            m = (JBCMethodCall)call;
            if (m.getMethodId() == 8) {
                Object[] args = m.getArgs();
                Fqn fqn = (Fqn)args[0];
                try {
                    PassivationInterceptor passivationInterceptor = this;
                    synchronized (passivationInterceptor) {
                        Map attributes = this.getNodeAttributes(fqn);
                        if (attributes != null) {
                            attributes.remove("jboss:internal:uninitialized");
                        }
                        this.cache.notifyNodePassivate(fqn, true);
                        this.loader.put(fqn, attributes);
                    }
                    if (this.statsEnabled && this.cache.getUseInterceptorMbeans()) {
                        this.m_passivations.increment();
                    }
                }
                catch (NodeNotLoadedException e) {
                    if (!this.log.isTraceEnabled()) break block8;
                    this.log.trace((Object)("Node " + fqn + " not loaded in memory; passivation skipped"));
                }
            }
        }
        return super.invoke(m);
    }

    public long getPassivations() {
        return this.m_passivations.get();
    }

    public void resetStatistics() {
        this.m_passivations.set(0L);
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("Passivations", new Long(this.m_passivations.get()));
        return retval;
    }

    private Map getNodeAttributes(Fqn fqn) throws NodeNotLoadedException {
        if (fqn == null) {
            throw new NodeNotLoadedException();
        }
        TreeNode n = this.cache.getRoot();
        int size = fqn.size();
        for (int i = 0; i < size && n != null; n = n.getChild(fqn.get(i)), ++i) {
        }
        if (n != null) {
            return n.getData();
        }
        throw new NodeNotLoadedException();
    }

    private static class NodeNotLoadedException
    extends Exception {
        private static final long serialVersionUID = -4078972305344328905L;

        private NodeNotLoadedException() {
        }
    }
}

