/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.parser;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.parser.PageRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractPage
implements Page {
    private Map properties = new HashMap();
    protected byte[] pageData = new byte[0];
    public HttpServletRequest request;

    public void writePage(OutputStream outputStream) throws IOException {
        outputStream.write(this.pageData);
    }

    public void writePage(Writer writer) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(this.pageData));
        while ((n = ((Reader)inputStreamReader).read()) != -1) {
            writer.write(n);
        }
    }

    public abstract void writeBody(Writer var1) throws IOException;

    public void writeBody(OutputStream outputStream) throws IOException {
        this.writeBody(new OutputStreamWriter(outputStream));
    }

    public String getTitle() {
        return this.noNull(this.getProperty("title"));
    }

    public int getContentLength() {
        return this.pageData.length;
    }

    public String getProperty(String string) {
        if (!this.isPropertySet(string)) {
            return null;
        }
        return (String)this.properties.get(string);
    }

    public int getIntProperty(String string) {
        try {
            return Integer.parseInt(this.noNull(this.getProperty(string)));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLongProperty(String string) {
        try {
            return Long.parseLong(this.noNull(this.getProperty(string)));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public boolean getBooleanProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null || string2.trim().length() == 0) {
            return false;
        }
        switch (string2.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertySet(String string) {
        return this.properties.containsKey(string);
    }

    public String[] getPropertyKeys() {
        Map map = this.properties;
        synchronized (map) {
            Set set = this.properties.keySet();
            String[] stringArray = set.toArray(new String[set.size()]);
            return stringArray;
        }
    }

    public boolean shouldCache() {
        return false;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        this.request = new PageRequest(httpServletRequest);
    }

    public void addProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    protected String noNull(String string) {
        return string == null ? "" : string;
    }
}

