/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.framework.ajax.AjaxEvent;
import org.ajax4jsf.framework.renderer.ComponentVariables;
import org.ajax4jsf.framework.renderer.ComponentsVariableResolver;
import org.ajax4jsf.framework.renderer.HeaderResourcesRendererBase;
import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.util.javascript.JSReference;
import org.ajax4jsf.framework.util.javascript.ScriptUtils;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.event.SwitchablePanelSwitchEvent;
import org.richfaces.renderkit.TabClassBuilder;
import org.richfaces.renderkit.TabInfoCollector;

public class TabPanelRendererBase
extends HeaderResourcesRendererBase {
    public static final String ACTIVE_CELL_CLASSES = "dr-tbpnl-tbcell-act rich-tabhdr-cell-active";
    public static final String INACTIVE_CELL_CLASSES = "dr-tbpnl-tbcell-inact rich-tabhdr-cell-inactive";
    public static final String DISABLED_CELL_CLASSES = "dr-tbpnl-tbcell-dsbld rich-tabhdr-cell-disabled";
    private static final TabInfoCollector collector = new TabInfoCollector(){
        private final JSReference JSR_ACTIVE_CLASS = new JSReference("activeClass");
        private final JSReference JSR_ID = new JSReference("id");
        private final JSReference JSR_INACTIVE_CLASS = new JSReference("inactiveClass");
        private final JSReference JSR_CELL_ACTIVE_CLASS = new JSReference("cellActiveClass");
        private final JSReference JSR_CELL_INACTIVE_CLASS = new JSReference("cellInactiveClass");

        public Object collectTabInfo(FacesContext context, UITab tab) {
            HashMap<JSReference, String> info = new HashMap<JSReference, String>();
            info.put(this.JSR_ID, tab.getClientId(context));
            info.put(this.JSR_ACTIVE_CLASS, TabPanelRendererBase.getActiveTabClass(tab));
            info.put(this.JSR_INACTIVE_CLASS, TabPanelRendererBase.getInactiveTabClass(tab));
            info.put(this.JSR_CELL_ACTIVE_CLASS, TabPanelRendererBase.ACTIVE_CELL_CLASSES);
            info.put(this.JSR_CELL_INACTIVE_CLASS, TabPanelRendererBase.INACTIVE_CELL_CLASSES);
            return info;
        }
    };
    static /* synthetic */ Class class$org$richfaces$component$UITabPanel;

    protected Class getComponentClass() {
        return class$org$richfaces$component$UITabPanel == null ? (class$org$richfaces$component$UITabPanel = TabPanelRendererBase.class$("org.richfaces.component.UITabPanel")) : class$org$richfaces$component$UITabPanel;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        UITabPanel panel = (UITabPanel)component;
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        UITab eventTab = null;
        Iterator tabsIterator = panel.getTabs();
        while (tabsIterator.hasNext() && eventTab == null) {
            String tabClientId;
            UITab tab = (UITab)tabsIterator.next();
            if (!tab.isRendered() || tab.isDisabled() || null == requestParameterMap.get(tabClientId = tab.getClientId(context)) && null == requestParameterMap.get(tabClientId + "_server_submit")) continue;
            eventTab = tab;
        }
        if (eventTab != null) {
            new SwitchablePanelSwitchEvent((UIComponent)panel, null, (UIComponent)eventTab).queue();
            new ActionEvent(eventTab).queue();
            if ("ajax".equals(eventTab.getSwitchType())) {
                new AjaxEvent((UIComponent)eventTab).queue();
            }
        } else {
            String newValue = (String)requestParameterMap.get(clientId);
            if (null != newValue) {
                new SwitchablePanelSwitchEvent((UIComponent)panel, newValue, null).queue();
            }
        }
    }

    public static String encodeStyles(FacesContext context, UIComponent component) throws IOException {
        String style;
        String widthAttrValue = (String)component.getAttributes().get("width");
        String heightAttrValue = (String)component.getAttributes().get("height");
        String styleAttrValue = (String)component.getAttributes().get("style");
        String string = style = styleAttrValue != null ? styleAttrValue : "";
        if (!TabPanelRendererBase.parameterPresent(styleAttrValue, "width")) {
            String width = widthAttrValue != null && widthAttrValue.length() > 0 ? HtmlUtil.qualifySize(widthAttrValue) : "100%";
            style = TabPanelRendererBase.addParameter(style, "width:" + width);
        }
        if (!TabPanelRendererBase.parameterPresent(styleAttrValue, "height")) {
            String height;
            String string2 = height = heightAttrValue != null && heightAttrValue.length() > 0 ? HtmlUtil.qualifySize(heightAttrValue) : "";
            if (height.length() > 0) {
                style = TabPanelRendererBase.addParameter(style, "height:" + height);
            }
        }
        return style;
    }

    protected static boolean parameterPresent(String style, String name) {
        if (style != null && style.length() > 0) {
            String[] styles = style.split(";");
            for (int i = 0; i < styles.length; ++i) {
                String[] pair = styles[i].split(":");
                if (!pair[0].trim().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static String addParameter(String style, String element) {
        String s = style.trim();
        return style + (s.length() == 0 || s.endsWith(";") ? "" : ";") + element;
    }

    protected String getValueAsString(FacesContext context, UITabPanel tabPanel) {
        return this.getUtils().getValueAsString(context, (UIComponent)tabPanel);
    }

    public void encodeTabs(FacesContext context, UITabPanel tabPanel) throws IOException {
        ComponentVariables componentVariables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)tabPanel);
        Object value = tabPanel.getValue();
        if (value instanceof String && ((String)value).length() == 0) {
            value = null;
        }
        if (value == null) {
            value = tabPanel.getSelectedTab();
        }
        boolean useFirstRenderedTab = value == null;
        UITabPanel pane = tabPanel;
        UITab firstRenderedTab = null;
        UITab activeTab = null;
        Iterator iter = pane.getTabs();
        while (iter.hasNext() && activeTab == null) {
            UITab tab = (UITab)iter.next();
            if (tab.isRendered()) {
                if (firstRenderedTab == null) {
                    firstRenderedTab = tab;
                }
                if (useFirstRenderedTab) {
                    activeTab = firstRenderedTab;
                    continue;
                }
                if (!value.equals(tab.getName())) continue;
                activeTab = tab;
                continue;
            }
            if (useFirstRenderedTab || !value.equals(tab.getName())) continue;
            if (firstRenderedTab != null) {
                activeTab = firstRenderedTab;
                continue;
            }
            useFirstRenderedTab = true;
        }
        if (activeTab == null) {
            throw new IllegalStateException("No active tabs!");
        }
        tabPanel.setValue(activeTab.getName());
        ArrayList<Object> tabs = new ArrayList<Object>();
        boolean clientSide = "client".equals(pane.getSwitchType());
        TabInfoCollector tabInfoCollector = this.getTabInfoCollector();
        Iterator iter2 = pane.getTabs();
        while (iter2.hasNext()) {
            UITab tab = (UITab)iter2.next();
            boolean active = activeTab == tab;
            tab.setActive(active);
            if (!tab.isRendered()) continue;
            if (!clientSide) {
                clientSide = "client".equals(tab.getSwitchType());
            }
            tab.encodeTab(context, active);
            if (tab.isDisabled()) continue;
            tabs.add(tabInfoCollector.collectTabInfo(context, tab));
        }
        componentVariables.setVariable("clientSide", (Object)new Boolean(clientSide));
        componentVariables.setVariable("tabs", tabs);
    }

    public static String getActiveTabCellClass(UITab tab) {
        return TabClassBuilder.activeTabClassBuilder.buildTabClass(tab);
    }

    public static String getDisabledTabCellClass(UITab tab) {
        return TabClassBuilder.disabledTabClassBuilder.buildTabClass(tab);
    }

    public static String getInactiveTabCellClass(UITab tab) {
        return TabClassBuilder.inactiveTabClassBuilder.buildTabClass(tab);
    }

    public static String getActiveTabClass(UITab tab) {
        return TabClassBuilder.activeTabClassBuilder.buildTabClass(tab);
    }

    public static String getDisabledTabClass(UITab tab) {
        return TabClassBuilder.disabledTabClassBuilder.buildTabClass(tab);
    }

    public static String getInactiveTabClass(UITab tab) {
        return TabClassBuilder.inactiveTabClassBuilder.buildTabClass(tab);
    }

    public void encodeTabsScript(FacesContext context, UITabPanel pane) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)pane);
        ArrayList tabs = (ArrayList)variables.getVariable("tabs");
        this.getUtils().writeScript(context, (UIComponent)pane, (Object)("RichFaces.panelTabs['" + pane.getClientId(context) + "']=" + ScriptUtils.toScript((Object)tabs) + ";"));
    }

    protected TabInfoCollector getTabInfoCollector() {
        return collector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

