/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.richfaces.component.util.MessageUtil;

public abstract class UIRangedNumberInput
extends UIInput {
    public abstract String getMaxValue();

    public abstract void setMaxValue(String var1);

    public abstract String getMinValue();

    public abstract void setMinValue(String var1);

    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && !this.isEmpty(newValue)) {
            String label = MessageUtil.getLabel(context, (UIComponent)this).toString();
            Double minValue = null;
            Double maxValue = null;
            Double value = null;
            try {
                minValue = this.convert(this.getMinValue());
                maxValue = this.convert(this.getMaxValue());
                value = this.convert(newValue);
            }
            catch (Exception e) {
                this.setValid(false);
                FacesMessage mess = new FacesMessage(label + ": " + e.getLocalizedMessage());
                mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), mess);
            }
            if (value != null) {
                if (null == minValue || null == maxValue) {
                    this.setValid(false);
                    FacesMessage mess = new FacesMessage(label + ": conversation error, maxValue or minValue is null!");
                    mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), mess);
                } else if (minValue > value) {
                    this.setValid(false);
                    FacesMessage mess = new FacesMessage(label + ": input value is less than minimal value!");
                    mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), mess);
                } else if (maxValue < value) {
                    this.setValid(false);
                    FacesMessage mess = new FacesMessage(label + ": input value is more than maximum value!");
                    mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), mess);
                }
            } else {
                this.setValid(false);
                FacesMessage mess = new FacesMessage(label + ": input value can't be null!");
                mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), mess);
            }
        }
        super.validateValue(context, newValue);
    }

    private Double convert(Object object) {
        if (object == null) {
            return null;
        }
        return new Double(object.toString());
    }

    private boolean isEmpty(Object newValue) {
        if (newValue == null) {
            return true;
        }
        if (newValue instanceof String) {
            return ((String)newValue).length() == 0;
        }
        return false;
    }
}

