/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;

class TabsIterator
implements Iterator {
    private FilterCondition filterCondition;
    private final UITabPanel tabsIterator;
    private Iterator _childs;
    private Object _next = null;

    public TabsIterator(UITabPanel tabPanel, FilterCondition filterCondition) {
        this.filterCondition = filterCondition;
        this.tabsIterator = tabPanel;
        this._childs = this.tabsIterator.getChildren().iterator();
        this._next = this.getNextTab();
    }

    public TabsIterator(UITabPanel tabPanel) {
        this(tabPanel, null);
    }

    public boolean hasNext() {
        return this._next != null;
    }

    public Object next() {
        if (null == this._next) {
            throw new NoSuchElementException();
        }
        Object next = this._next;
        this._next = this.getNextTab();
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException("tabs Iterator not support remove operation");
    }

    private Object getNextTab() {
        while (this._childs.hasNext()) {
            Object element = this._childs.next();
            if (!(element instanceof UITab)) continue;
            UITab tab = (UITab)element;
            if (this.filterCondition != null && !this.filterCondition.isSuitable(tab)) continue;
            return tab;
        }
        return null;
    }

    static interface FilterCondition {
        public boolean isSuitable(UITab var1);
    }
}

