/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.native2ascii;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.optional.native2ascii.KaffeNative2Ascii;
import org.apache.tools.ant.taskdefs.optional.native2ascii.Native2AsciiAdapter;
import org.apache.tools.ant.taskdefs.optional.native2ascii.SunNative2Ascii;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Native2AsciiAdapterFactory {
    public static String getDefault() {
        if (JavaEnvUtils.isKaffe()) {
            return "kaffe";
        }
        return "sun";
    }

    public static Native2AsciiAdapter getAdapter(String choice, ProjectComponent log) throws BuildException {
        if (JavaEnvUtils.isKaffe() && choice == null || "kaffe".equals(choice)) {
            return new KaffeNative2Ascii();
        }
        if ("sun".equals(choice)) {
            return new SunNative2Ascii();
        }
        if (choice != null) {
            return Native2AsciiAdapterFactory.resolveClassName(choice);
        }
        return new SunNative2Ascii();
    }

    private static Native2AsciiAdapter resolveClassName(String className) throws BuildException {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            return (Native2AsciiAdapter)o;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException("Can't load " + className, (Throwable)cnfe);
        }
        catch (ClassCastException cce) {
            throw new BuildException(className + " is not a Native2Ascii adapter", (Throwable)cce);
        }
        catch (Throwable t) {
            throw new BuildException(className + " caused an interesting " + "exception.", t);
        }
    }
}

