/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;
import org.jgroups.util.Util;

public class ContinousThroughputTest {
    String props = "UDP:PING(up_thread=false;down_thread=false):FD(timeout=1000;shun=false):STABLE(up_thread=false;down_thread=false):MERGE(up_thread=false;down_thread=false):NAKACK:FLUSH:GMS:VIEW_ENFORCER(up_thread=false;down_thread=false):QUEUE(up_thread=false;down_thread=false)";
    JChannel channel = null;
    Thread sendThread = new Thread("sendThread"){

        public void run() {
            ContinousThroughputTest.this.parser();
        }
    };
    Thread receiveThread = new Thread("receiveThread"){

        public void run() {
            ContinousThroughputTest.this.checkChannel();
        }
    };
    boolean coordinator = false;
    IpAddress my_addr = null;
    View view;
    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    float troughputSum = 0.0f;
    float meanTroughput = 0.0f;
    float minTroughput = 10000.0f;
    float maxTroughput = 0.0f;
    int numTests = 0;
    FileWriter logWriter;
    Protocol prot = null;

    public ContinousThroughputTest() {
        try {
            this.channel = new JChannel(this.props);
            this.channel.setOpt(0, Boolean.FALSE);
            this.channel.connect("Janus");
        }
        catch (Exception ex) {
            System.out.println("Connection Failed!" + ex);
            System.exit(1);
        }
        this.my_addr = (IpAddress)this.channel.getLocalAddress();
        try {
            File log = new File("ContinousThroughputTest" + this.my_addr.getIpAddress().getHostName() + System.currentTimeMillis() / 10000L + ".log");
            if (!log.exists()) {
                log.createNewFile();
            }
            this.logWriter = new FileWriter(log);
            this.logWriter.write("ContinousThroughputTest.java log\r\n");
            this.logWriter.write("Date:" + new Date(System.currentTimeMillis()) + "\r\n");
            this.log("Protocol Stack is " + this.props);
            System.out.println("Protocol Stack is " + this.props);
        }
        catch (Exception ex) {
            System.out.println("File problems " + ex);
            System.exit(5);
        }
    }

    public static void main(String[] args) {
        ContinousThroughputTest perfTest = new ContinousThroughputTest();
        perfTest.go();
    }

    void go() {
        this.receiveThread.start();
        this.sendThread.start();
    }

    public void checkChannel() {
        String payload = null;
        Object received = null;
        Message msg = null;
        boolean done = false;
        int i = 1;
        System.out.println("Started receiving");
        try {
            while (!done) {
                received = this.channel.receive(0L);
                if (received instanceof Message) {
                    long n;
                    msg = (Message)received;
                    payload = (String)msg.getObject();
                    System.out.println(payload);
                    if ("stop".equalsIgnoreCase(payload)) {
                        done = true;
                    }
                    if ("pingpong".equalsIgnoreCase(payload)) {
                        n = (Long)((Message)this.channel.receive(0L)).getObject();
                        i = (Integer)((Message)this.channel.receive(0L)).getObject();
                        this.log("Starting pingpong test. Rounds: " + n + " Bursts: " + i);
                        this.pingpongTest(n, i, false);
                    }
                    if ("cping".equalsIgnoreCase(payload)) {
                        this.log("Starting cping test. Bursts: 1");
                        this.cpingTest(1, true);
                    }
                    if ("sweep".equalsIgnoreCase(payload)) {
                        n = (Long)((Message)this.channel.receive(0L)).getObject();
                        i = (Integer)((Message)this.channel.receive(0L)).getObject();
                        this.log("Starting sweep test. Rounds: " + n + " initial burst: " + i);
                        this.sweep(n, i);
                    }
                }
                if (!(received instanceof View)) continue;
                this.view = (View)received;
                System.out.println(this.view);
                if (this.view.getMembers().elementAt(0).equals(this.my_addr)) {
                    System.out.println("I'm the new Coordinator");
                    this.coordinator = true;
                }
                this.resetData();
            }
        }
        catch (Exception ex) {
            System.out.println("checkChannel() :" + ex);
            try {
                this.logWriter.write("Stopped cause " + ex + "\r\n");
            }
            catch (Exception e) {
                // empty catch block
            }
            System.exit(2);
        }
        System.out.println("Stopped Receiving");
        this.channel.disconnect();
        System.out.println("Disconnected from \"Janus\"");
        this.channel.close();
        System.out.println("Channel Closed");
        System.exit(0);
    }

    public void parser() {
        boolean done = false;
        int number = 0;
        int burstlength = 1;
        System.out.println("Ready.");
        try {
            while (!done) {
                String input = this.reader.readLine();
                if ("stop".equalsIgnoreCase(input)) {
                    done = true;
                }
                if ("pingpong".equalsIgnoreCase(input)) {
                    number = this.askNumber(this.reader, "How many rounds?");
                    burstlength = this.askNumber(this.reader, "Length of bursts?");
                    this.channel.send(new Message(null, null, (Serializable)((Object)input)));
                    this.channel.send(new Message(null, null, new Long(number)));
                    this.channel.send(new Message(null, null, new Integer(burstlength)));
                    continue;
                }
                if ("cping".equalsIgnoreCase(input)) {
                    this.channel.send(new Message(null, null, (Serializable)((Object)input)));
                    continue;
                }
                if ("sweep".equalsIgnoreCase(input)) {
                    number = this.askNumber(this.reader, "Number of tests");
                    burstlength = this.askNumber(this.reader, "Initial length of bursts?");
                    this.channel.send(new Message(null, null, (Serializable)((Object)input)));
                    this.channel.send(new Message(null, null, new Long(number)));
                    this.channel.send(new Message(null, null, new Integer(burstlength)));
                    continue;
                }
                this.channel.send(new Message(null, null, (Serializable)((Object)input)));
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    void sendBurst(long n) {
        try {
            byte[] buf = Util.objectToByteBuffer("Standard Mex");
            int i = 0;
            while ((long)i < n) {
                this.channel.send(new Message(null, null, buf));
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("sendBurst: " + ex);
        }
    }

    void showStats(long start, long stop, long messages, int burstlength) {
        long elapsedTime = stop - start;
        long troughPut = messages * 1000L / elapsedTime;
        this.maxTroughput = this.maxTroughput > (float)troughPut ? this.maxTroughput : (float)troughPut;
        this.minTroughput = this.minTroughput < (float)troughPut ? this.minTroughput : (float)troughPut;
        String result = "Elapsed Time: " + (stop - start) + "| messages:" + messages + "| burst length:" + burstlength + "| Troughput:" + troughPut + "| max: " + this.maxTroughput + "| min: " + this.minTroughput + "\r\n";
        System.out.println(result);
        try {
            this.logWriter.write(result);
            this.logWriter.flush();
        }
        catch (Exception ex) {
            System.out.println("showStats():" + ex);
        }
    }

    int askNumber(BufferedReader reader, String text) {
        int number = 0;
        String input = "10";
        System.out.println(text);
        try {
            input = reader.readLine();
        }
        catch (Exception ex) {
            System.out.println("AskNumber :" + ex);
        }
        number = Integer.parseInt(input);
        return number;
    }

    void resetData() {
        this.maxTroughput = 0.0f;
        this.minTroughput = 10000.0f;
        this.meanTroughput = 0.0f;
        this.numTests = 0;
        this.troughputSum = 0.0f;
    }

    void pingpongTest(long n, int burst_length, boolean partialResultsPrint) {
        long stop;
        long i = 0L;
        long start = System.currentTimeMillis();
        long tempstart = System.currentTimeMillis();
        try {
            for (i = 0L; i < n; ++i) {
                for (int k = 0; k < burst_length; ++k) {
                    this.channel.send(new Message(null, null, new Long(i)));
                }
                for (int j = 0; j < this.view.size() * burst_length; ++j) {
                    this.channel.receive(20000L);
                }
                if (!partialResultsPrint || i % 1000L != 0L || i == 0L) continue;
                stop = System.currentTimeMillis();
                long throughput = 1000000L / (stop - tempstart) * (long)this.view.size() * (long)burst_length;
                try {
                    System.out.println(new Date(stop).toString() + " : " + throughput);
                    this.logWriter.write(new Date(stop).toString() + " : " + throughput);
                    this.logWriter.write("\r\n");
                    this.logWriter.flush();
                    tempstart = System.currentTimeMillis();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (TimeoutException ex) {
            System.out.println("Timeout Receiving, round: " + i);
            System.exit(5);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(4);
        }
        stop = System.currentTimeMillis();
        this.showStats(start, stop, n * (long)this.view.size() * (long)burst_length, burst_length);
    }

    void sweep(long tests, int burstlenght) {
        long messagespertest = 10000L;
        int i = 0;
        while ((long)i < tests) {
            this.pingpongTest(messagespertest / (long)(burstlenght += i), burstlenght, false);
            ++i;
        }
    }

    void cpingTest(int burst_lenght, boolean printoutput) {
        Object recvd = null;
        long start = System.currentTimeMillis();
        for (long i = 1L; i < Long.MAX_VALUE; ++i) {
            try {
                this.channel.send(null, null, (Serializable)((Object)"cping"));
                int j = 0;
                while (j < burst_lenght * this.view.size()) {
                    recvd = this.channel.receive(10000L);
                    if (recvd instanceof View) {
                        this.view = (View)recvd;
                        System.out.println(this.view);
                        this.log(this.view.toString());
                        continue;
                    }
                    ++j;
                }
            }
            catch (TimeoutException tex) {
                try {
                    this.channel.send(new Message(null, null, (Serializable)((Object)"cping")));
                    System.out.println("Resent a message for timeout");
                    this.log("Resent a message for timeout");
                }
                catch (Exception ex) {
                    System.exit(9);
                }
            }
            catch (Exception ex) {
                System.exit(9);
            }
            if (i % 1000L != 0L) continue;
            long stop = System.currentTimeMillis();
            long throughput = i * 1000L * (long)this.view.size() / (stop - start);
            System.out.println("Througputh = " + throughput);
            this.log("Througputh = " + throughput);
            start = System.currentTimeMillis();
            i = 0L;
        }
    }

    void log(String str) {
        try {
            this.logWriter.write(str + "\r\n");
            this.logWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class MessageLenghtObserver
    implements ProtocolObserver {
        public void setProtocol(Protocol prot) {
            throw new UnsupportedOperationException("Method setProtocol() not yet implemented.");
        }

        public boolean up(Event evt, int num_evts) {
            throw new UnsupportedOperationException("Method up() not yet implemented.");
        }

        public boolean passUp(Event evt) {
            return true;
        }

        public boolean down(Event evt, int num_evts) {
            return true;
        }

        public boolean passDown(Event evt) {
            byte[] buf = null;
            if (evt.getType() == 1) {
                try {
                    buf = Util.objectToByteBuffer(evt.getArg());
                    System.out.println("UDP: sending a message of " + buf.length + "bytes");
                    System.out.println("Message was :");
                    System.out.println(new String(buf));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    }
}

