/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTable;
import org.jgroups.blocks.ConnectionTableNIO;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class ConnectionTableTest
extends TestCase {
    private BasicConnectionTable ct1;
    private BasicConnectionTable ct2;
    static String bind_addr_str;
    static InetAddress bind_addr;
    static byte[] data;
    Address addr1;
    Address addr2;
    int active_threads = 0;
    static final int PORT1 = 7521;
    static final int PORT2 = 8931;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectionTableTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        System.out.println("Starting: " + this.getName());
        super.setUp();
        this.active_threads = Thread.activeCount();
        System.out.println("active threads before (" + this.active_threads + "):\n" + Util.activeThreads());
        this.addr1 = new IpAddress(bind_addr, 7521);
        this.addr2 = new IpAddress(bind_addr, 8931);
    }

    protected void tearDown() throws Exception {
        if (this.ct2 != null) {
            this.ct2.stop();
            this.ct2 = null;
        }
        if (this.ct1 != null) {
            this.ct1.stop();
            this.ct1 = null;
        }
        Util.sleep(100L);
        super.tearDown();
        System.out.println("Ending: " + this.getName());
    }

    public void testConcurrentConnect() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(3);
        this.ct1 = new ConnectionTable(bind_addr, 7521);
        this.ct2 = new ConnectionTable(bind_addr, 8931);
        BasicConnectionTable.Receiver dummy = new BasicConnectionTable.Receiver(){

            public void receive(Address sender, byte[] data, int offset, int length) {
            }
        };
        this.ct1.setReceiver(dummy);
        this.ct2.setReceiver(dummy);
        Sender sender1 = new Sender((ConnectionTable)this.ct1, barrier, this.addr2, 0L);
        Sender sender2 = new Sender((ConnectionTable)this.ct2, barrier, this.addr1, 0L);
        sender1.start();
        sender2.start();
        Util.sleep(100L);
        System.out.println("ct1: " + this.ct1 + "ct2: " + this.ct2);
        int num_conns = this.ct1.getNumConnections();
        if (!$assertionsDisabled && num_conns != 0) {
            throw new AssertionError();
        }
        num_conns = this.ct2.getNumConnections();
        if (!$assertionsDisabled && num_conns != 0) {
            throw new AssertionError();
        }
        barrier.attemptBarrier(10000L);
        sender1.join();
        sender2.join();
        System.out.println("ct1: " + this.ct1 + "\nct2: " + this.ct2);
        num_conns = this.ct1.getNumConnections();
        if (!$assertionsDisabled && num_conns != 1) {
            throw new AssertionError((Object)("num_conns is " + num_conns));
        }
        num_conns = this.ct2.getNumConnections();
        if (!$assertionsDisabled && num_conns != 1) {
            throw new AssertionError();
        }
        Util.sleep(500L);
        System.out.println("ct1: " + this.ct1 + "\nct2: " + this.ct2);
        num_conns = this.ct1.getNumConnections();
        if (!$assertionsDisabled && num_conns != 1) {
            throw new AssertionError();
        }
        num_conns = this.ct2.getNumConnections();
        if (!$assertionsDisabled && num_conns != 1) {
            throw new AssertionError();
        }
        BasicConnectionTable.Connection connection = this.ct1.getConnection(this.addr2);
        if (!$assertionsDisabled && connection.isSocketClosed()) {
            throw new AssertionError((Object)"valid connection to peer");
        }
        connection = this.ct2.getConnection(this.addr1);
        if (!$assertionsDisabled && connection.isSocketClosed()) {
            throw new AssertionError((Object)"valid connection to peer");
        }
    }

    public void testStopConnectionTable() throws Exception {
        this.ct1 = new ConnectionTable(new DummyReceiver(), bind_addr, null, 7521, 7521, 60000L, 120000L);
        this.ct2 = new ConnectionTable(new DummyReceiver(), bind_addr, null, 8931, 8931, 60000L, 120000L);
        this._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionTableNIO() throws Exception {
        this.ct1 = new ConnectionTableNIO(new DummyReceiver(), bind_addr, null, 7521, 7521, 60000L, 120000L, false);
        this.ct2 = new ConnectionTableNIO(new DummyReceiver(), bind_addr, null, 8931, 8931, 60000L, 120000L, false);
        this.ct1.start();
        this.ct2.start();
        this._testStop(this.ct1, this.ct2);
    }

    private void _testStop(BasicConnectionTable table1, BasicConnectionTable table2) throws Exception {
        table1.send(this.addr1, data, 0, data.length);
        ConnectionTableTest.assertEquals((int)0, (int)table1.getNumConnections());
        table1.send(this.addr2, data, 0, data.length);
        table2.send(this.addr2, data, 0, data.length);
        table2.send(this.addr1, data, 0, data.length);
        System.out.println("table1:\n" + table1 + "\ntable2:\n" + table2);
        ConnectionTableTest.assertEquals((int)1, (int)table1.getNumConnections());
        ConnectionTableTest.assertEquals((int)1, (int)table2.getNumConnections());
        table2.stop();
        table1.stop();
        ConnectionTableTest.assertEquals((int)0, (int)table1.getNumConnections());
        ConnectionTableTest.assertEquals((int)0, (int)table2.getNumConnections());
        Util.sleep(1000L);
        int current_active_threads = Thread.activeCount();
        System.out.println("active threads after (" + current_active_threads + "):\n" + Util.activeThreads());
        ConnectionTableTest.assertEquals((int)this.active_threads, (int)current_active_threads);
    }

    public static Test suite() {
        return new TestSuite(ConnectionTableTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ConnectionTableTest.suite());
    }

    static {
        $assertionsDisabled = !ConnectionTableTest.class.desiredAssertionStatus();
        bind_addr_str = null;
        bind_addr = null;
        data = new byte[]{98, 101, 108, 97};
        try {
            bind_addr_str = System.getProperty("jgroups.bind_addr", "127.0.0.1");
            bind_addr = InetAddress.getByName(bind_addr_str);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    static class DummyReceiverNIO
    implements BasicConnectionTable.Receiver {
        DummyReceiverNIO() {
        }

        public void receive(Address sender, byte[] data, int offset, int length) {
        }
    }

    static class DummyReceiver
    implements BasicConnectionTable.Receiver {
        DummyReceiver() {
        }

        public void receive(Address sender, byte[] data, int offset, int length) {
        }
    }

    private static class Sender
    extends Thread {
        final ConnectionTable conn_table;
        final CyclicBarrier barrier;
        final Address dest;
        final long sleep_time;

        public Sender(ConnectionTable conn_table, CyclicBarrier barrier, Address dest, long sleep_time) {
            this.conn_table = conn_table;
            this.barrier = barrier;
            this.dest = dest;
            this.sleep_time = sleep_time;
        }

        public void run() {
            try {
                this.barrier.attemptBarrier(10000L);
                if (this.sleep_time > 0L) {
                    Util.sleep(this.sleep_time);
                }
                this.conn_table.send(this.dest, data, 0, data.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

