/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.variable.def;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.variable.def.VariableType;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;

public class VariableDefinition
implements Serializable {
    long id;
    private String name;
    private VariableType type;
    private static final long serialVersionUID = 1L;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VariableType getType() {
        return this.type;
    }

    public void setType(VariableType type) {
        this.type = type;
    }

    public void createInstance(Token token) {
        ContextInstance contextInstance = token.getProcessInstance().getContextInstance();
        contextInstance.createVariable(this.name, this.type.createValue(this), token);
    }

    public void createInstance(Token token, Object value) {
        ContextInstance contextInstance = token.getProcessInstance().getContextInstance();
        contextInstance.createVariable(this.name, value, token);
    }

    public Object getValue(Token token) {
        Object value = this.getValueForAssign(token);
        if (!this.type.isInitialized(value)) {
            throw new BpelFaultException(BpelConstants.FAULT_UNINITIALIZED_VARIABLE);
        }
        return value;
    }

    public Object getValueForAssign(Token token) {
        ContextInstance context = token.getProcessInstance().getContextInstance();
        return context.getVariable(this.name, token);
    }

    public void setValue(Token token, Object newValue) {
        Object currentValue = this.getValueForAssign(token);
        this.type.setValue(currentValue, newValue);
    }

    public Object getPropertyValue(QName propertyName, Token token) {
        return this.type.getPropertyValue(propertyName, this.getValue(token));
    }

    public void setPropertyValue(QName propertyName, Token token, Object propertyValue) {
        this.type.setPropertyValue(propertyName, this.getValue(token), propertyValue);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("type", (Object)this.type).toString();
    }
}

