/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.integration.exe.PartnerLinkInstance;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.OutstandingRequest;
import org.jbpm.bpel.integration.jms.RequestListener;
import org.jbpm.bpel.integration.jms.StartListener;
import org.jbpm.bpel.persistence.db.IntegrationSession;
import org.jbpm.graph.exe.Token;

public class IntegrationConsole
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<body>");
        out.println("<h1>JBoss jBPM BPEL</h1>");
        out.println("<h2>Partner Relationships Console</h2>");
        IntegrationControl integrationControl = (IntegrationControl)this.getServletContext().getAttribute("jbpm.bpel.integration.control");
        this.printGeneralDetails(out, integrationControl);
        JbpmConfiguration jbpmConfiguration = integrationControl.getIntegrationServiceFactory().getJbpmConfiguration();
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            this.printRequestListeners(out, jbpmContext, integrationControl);
            this.printPortConsumers(out, jbpmContext, integrationControl);
            this.printStartListeners(out, jbpmContext, integrationControl);
            this.printOutstandingRequests(out, jbpmContext, integrationControl);
        }
        finally {
            jbpmContext.close();
        }
        out.println("</body>");
        out.println("</html>");
    }

    protected void printGeneralDetails(PrintWriter out, IntegrationControl integrationControl) {
        out.println("<h2>General details</h2>");
        out.println("<table border='1'>");
        out.println("<tr><td>Process name</td><td>" + integrationControl.getAppDescriptor().getName() + "</td></tr>");
        out.println("</table>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printRequestListeners(PrintWriter out, JbpmContext jbpmContext, IntegrationControl integrationControl) {
        Map requestListeners;
        out.println("<h2>Request listeners</h2>");
        out.println("<table border='1'>");
        out.println("<tr><th>Activity</th><th>Partner link</th><th>Operation</th><th>Token</th><th>Request listener</th></tr>");
        IntegrationSession integrationSession = IntegrationSession.getInstance(jbpmContext);
        Map map = requestListeners = integrationControl.getRequestListeners();
        synchronized (map) {
            Iterator entryIt = requestListeners.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = entryIt.next();
                RequestListener.Key key = (RequestListener.Key)entry.getKey();
                ReceiveAction receiveAction = integrationSession.loadReceiver(key.getReceiverId());
                Token token = jbpmContext.loadToken(key.getTokenId());
                out.println("<tr><td>" + token.getNode() + "</td>" + "<td>" + receiveAction.getPartnerLink() + "</td>" + "<td>" + receiveAction.getOperation().getName() + "</td>" + "<td>" + token + "</td>" + "<td>" + entry.getValue() + "</td>" + "</tr>");
            }
        }
        out.println("</table>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printOutstandingRequests(PrintWriter out, JbpmContext jbpmContext, IntegrationControl integrationControl) {
        Map outstandingRequests;
        out.println("<h2>Outstanding requests</h2>");
        out.println("<table border='1'>");
        out.println("<tr><th>Partner link</th><th>Operation</th><th>Message exchange</th><th>Outstanding request</th></tr>");
        IntegrationSession integrationSession = IntegrationSession.getInstance(jbpmContext);
        Map map = outstandingRequests = integrationControl.getOutstandingRequests();
        synchronized (map) {
            Iterator entryIt = outstandingRequests.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = entryIt.next();
                OutstandingRequest.Key key = (OutstandingRequest.Key)entry.getKey();
                PartnerLinkInstance partnerLinkInstance = integrationSession.loadPartnerLinkInstance(key.getPartnerLinkId());
                out.println("<tr><td>" + partnerLinkInstance + "</td>" + "<td>" + key.getOperationName() + "</td>" + "<td>" + key.getMessageExchange() + "</td>" + "<td>" + entry.getValue() + "</td>" + "</tr>");
            }
        }
        out.println("</table>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printPortConsumers(PrintWriter out, JbpmContext jbpmContext, IntegrationControl integrationControl) {
        Map portConsumers;
        out.println("<h2>Port consumers</h2>");
        out.println("<table border='1'>");
        out.println("<tr><th>Partner link</th><th>Port consumer</th></tr>");
        IntegrationSession integrationSession = IntegrationSession.getInstance(jbpmContext);
        Map map = portConsumers = integrationControl.getPartnerClients();
        synchronized (map) {
            Iterator entryIt = portConsumers.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = entryIt.next();
                PartnerLinkInstance partnerLinkInstance = integrationSession.loadPartnerLinkInstance((Long)entry.getKey());
                out.println("<tr><td>" + partnerLinkInstance + "</td>" + "<td>" + entry.getValue() + "</td>" + "</tr>");
            }
        }
        out.println("</table>");
    }

    protected void printStartListeners(PrintWriter out, JbpmContext jbpmContext, IntegrationControl integrationControl) {
        out.println("<h2>Start listeners</h2>");
        out.println("<table border='1'>");
        out.println("<tr><th>Partner link</th><th>Operation</th><th>Start listener</th></tr>");
        IntegrationSession integrationSession = IntegrationSession.getInstance(jbpmContext);
        List startListeners = integrationControl.getStartListeners();
        Iterator elementIt = startListeners.iterator();
        while (elementIt.hasNext()) {
            StartListener startListener = (StartListener)elementIt.next();
            ReceiveAction receiveAction = integrationSession.loadReceiver(startListener.getReceiverId());
            out.println("<tr><td>" + receiveAction.getPartnerLink() + "</td>" + "<td>" + receiveAction.getOperation().getName() + "</td>" + "<td>" + startListener + "</td>" + "</tr>");
        }
        out.println("</table>");
    }
}

