/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.JmsIntegrationService;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;

public class JmsIntegrationServiceFactory
implements ServiceFactory {
    private String defaultDestinationName;
    private String defaultConnectionFactoryName;
    private JbpmConfiguration jbpmConfiguration;
    private Destination defaultDestination;
    private ConnectionFactory defaultConnectionFactory;
    private Map integrationControls = new HashMap();
    private static final Log log = LogFactory.getLog((Class)JmsIntegrationServiceFactory.class);
    private static final long serialVersionUID = 1L;

    public Service openService() {
        return new JmsIntegrationService(this);
    }

    public void close() {
        Iterator integrationControlIt = this.integrationControls.values().iterator();
        while (integrationControlIt.hasNext()) {
            IntegrationControl integrationControl = (IntegrationControl)integrationControlIt.next();
            try {
                integrationControl.disableInboundMessageActivities();
            }
            catch (JMSException e) {
                log.debug((Object)"could not close integration control", (Throwable)e);
            }
        }
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public IntegrationControl getIntegrationControl(ProcessDefinition processDefinition) {
        Long processId = new Long(processDefinition.getId());
        IntegrationControl integrationControl = (IntegrationControl)this.integrationControls.get(processId);
        if (integrationControl == null) {
            log.debug((Object)("creating integration control: processDefinition=" + processDefinition));
            integrationControl = new IntegrationControl(this);
            this.integrationControls.put(processId, integrationControl);
        }
        return integrationControl;
    }

    public ConnectionFactory getDefaultConnectionFactory() {
        if (this.defaultConnectionFactory == null && this.defaultConnectionFactoryName != null) {
            try {
                this.defaultConnectionFactory = this.createDefaultConnectionFactory();
            }
            catch (Exception e) {
                log.debug((Object)"could not create default connection", (Throwable)e);
            }
        }
        return this.defaultConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionFactory createDefaultConnectionFactory() throws NamingException {
        InitialContext initialContext = new InitialContext();
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup(this.defaultConnectionFactoryName);
            return connectionFactory;
        }
        finally {
            initialContext.close();
        }
    }

    public Destination getDefaultDestination() {
        if (this.defaultDestination == null && this.defaultDestinationName != null) {
            try {
                this.defaultDestination = this.createDefaultDestination();
            }
            catch (Exception e) {
                log.debug((Object)"could not create default destination", (Throwable)e);
            }
        }
        return this.defaultDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination createDefaultDestination() throws NamingException {
        InitialContext initialContext = new InitialContext();
        try {
            Destination destination = (Destination)initialContext.lookup(this.defaultDestinationName);
            return destination;
        }
        finally {
            initialContext.close();
        }
    }

    public static JmsIntegrationServiceFactory getInstance(JbpmConfiguration jbpmConfiguration) {
        return (JmsIntegrationServiceFactory)jbpmConfiguration.getServiceFactory("integration");
    }
}

