/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.def;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.integration.IntegrationService;
import org.jbpm.bpel.integration.def.Correlations;
import org.jbpm.bpel.integration.def.MessageAction;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class InvokeAction
extends MessageAction
implements Serializable {
    private VariableDefinition inputVariable;
    private VariableDefinition outputVariable;
    private Correlations inCorrelations;
    private Correlations outCorrelations;
    private static final long serialVersionUID = 1L;

    public VariableDefinition getInputVariable() {
        return this.inputVariable;
    }

    public void setInputVariable(VariableDefinition inputVariable) {
        this.inputVariable = inputVariable;
    }

    public VariableDefinition getOutputVariable() {
        return this.outputVariable;
    }

    public void setOutputVariable(VariableDefinition outputVariable) {
        this.outputVariable = outputVariable;
    }

    public Correlations getInCorrelations() {
        return this.inCorrelations;
    }

    public void setInCorrelations(Correlations correlations) {
        this.inCorrelations = correlations;
    }

    public Correlations getOutCorrelations() {
        return this.outCorrelations;
    }

    public void setOutCorrelations(Correlations outCorrelations) {
        this.outCorrelations = outCorrelations;
    }

    public void execute(ExecutionContext exeContext) {
        IntegrationService integrationService = ReceiveAction.getIntegrationService(exeContext.getJbpmContext());
        integrationService.invoke(this, exeContext.getToken());
        exeContext.leaveNode();
    }

    public Map writeMessage(Token token) {
        MessageValue messageValue = (MessageValue)this.inputVariable.getValue(token);
        if (this.outCorrelations != null) {
            this.outCorrelations.ensureConstraint(messageValue, token);
        }
        return messageValue.getParts();
    }

    public void readMessage(Map outputParts, Token token) {
        MessageValue messageValue = (MessageValue)this.outputVariable.getValueForAssign(token);
        messageValue.setParts(outputParts);
        if (this.inCorrelations != null) {
            this.inCorrelations.ensureConstraint(messageValue, token);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("partnerLink", (Object)this.getPartnerLink().getName()).append("operation", (Object)this.getOperation().getName()).toString();
    }
}

