/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.scope;

import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.graph.exe.FaultInstance;
import org.jbpm.bpel.graph.scope.Handler;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.variable.exe.MessageValue;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class Catch
extends Handler {
    private QName faultName;
    private VariableDefinition faultVariable;
    private static final long serialVersionUID = 1L;

    public void execute(ExecutionContext exeContext) {
        if (this.faultVariable != null) {
            VariableDefinition scopeVariable = this.getCompositeActivity().findVariable(this.faultVariable.getName());
            if (this.faultVariable.equals(scopeVariable)) {
                this.setFaultVariable(exeContext.getToken());
            } else {
                this.initFaultVariable(exeContext.getToken());
            }
        }
        super.execute(exeContext);
    }

    public VariableDefinition findVariable(String name) {
        return this.faultVariable != null && this.faultVariable.getName().equals(name) ? this.faultVariable : super.findVariable(name);
    }

    protected void initFaultVariable(Token token) {
        FaultInstance faultInstance = Scope.getInstance(token).getFaultInstance();
        MessageValue messageData = faultInstance.getMessageValue();
        Object faultData = messageData != null ? (messageData.getType().equals(this.faultVariable.getType()) ? messageData : messageData.getParts().values().iterator().next()) : faultInstance.getElementValue();
        this.faultVariable.createInstance(token, faultData);
    }

    protected void setFaultVariable(Token token) {
        FaultInstance faultInstance = Scope.getInstance(token).getFaultInstance();
        this.faultVariable.setValue(token, faultInstance.getMessageValue());
    }

    public QName getFaultName() {
        return this.faultName;
    }

    public void setFaultName(QName faultName) {
        this.faultName = faultName;
    }

    public VariableDefinition getFaultVariable() {
        return this.faultVariable;
    }

    public void setFaultVariable(VariableDefinition faultVariable) {
        this.faultVariable = faultVariable;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        if (this.faultName != null) {
            builder.append("name", (Object)this.faultName);
        }
        if (this.faultVariable != null) {
            builder.append("variable", (Object)this.faultVariable);
        }
        return builder.toString();
    }
}

