/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.type;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.Mapping;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.type.AbstractType;
import cirrus.hibernate.type.AssociationType;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

public abstract class PersistentCollectionType
extends AbstractType
implements AssociationType {
    private final String role;
    private static final int[] NO_INTS = new int[0];
    private final boolean nested;

    public PersistentCollectionType(String role, boolean nested) {
        this.role = role;
        this.nested = nested;
    }

    public boolean isNested() {
        return this.nested;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isPersistentCollectionType() {
        return true;
    }

    public final boolean equals(Object x, Object y) {
        return x == y;
    }

    protected abstract PersistentCollection instantiate(SessionImplementor var1, CollectionPersister var2) throws HibernateException;

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(this.hydrate(rs, name, session, owner), session);
    }

    public Object getCollection(Serializable id, SessionImplementor session) throws HibernateException, SQLException {
        CollectionPersister persister = session.getFactory().getCollectionPersister(this.role);
        PersistentCollection collection = persister.getCachedCollection(id, session);
        if (collection != null) {
            session.addInitializedCollection(collection, persister, id);
            return collection.getCachedValue();
        }
        collection = this.instantiate(session, persister);
        session.addUninitializedCollection(collection, persister, id);
        return collection.getInitialValue(persister.isLazy());
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (!this.nested) {
            Serializable id = value == null ? null : session.getCurrentID((PersistentCollection)value);
            session.getFactory().getCollectionKeyType(this.role).nullSafeSet(st, id, index, session);
        }
    }

    public int[] sqlTypes(Mapping session) throws MappingException {
        if (!this.nested) {
            return session.getCollectionKeyType(this.role).sqlTypes(session);
        }
        return NO_INTS;
    }

    public int getColumnSpan(Mapping session) throws MappingException {
        if (!this.nested) {
            return 1;
        }
        return 0;
    }

    public String toXML(Object value, SessionFactoryImplementor factory) {
        return value == null ? null : value.toString();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public String getName() {
        return this.returnedClass().getName();
    }

    public Iterator getElementsIterator(Object collection) {
        return ((Collection)collection).iterator();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = session.getLoadedID((PersistentCollection)value);
        if (id == null) {
            throw new AssertionFailure("Null collection id");
        }
        return id;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(cached, session);
    }

    public boolean isDirty(Object old, Object current, Object owner, SessionFactoryImplementor factory) throws HibernateException {
        if (this.nested && !factory.getPersister(owner.getClass()).isVersioned()) {
            return false;
        }
        return super.isDirty(old, current, owner, factory);
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public abstract PersistentCollection wrap(SessionImplementor var1, Object var2);

    public boolean isAssociationType() {
        return true;
    }

    public AssociationType.ForeignKeyType getForeignKeyType() {
        return AssociationType.FOREIGN_KEY_TO_PARENT;
    }

    public Object hydrate(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        if (this.nested) {
            return session.getID(owner);
        }
        CollectionPersister persister = session.getFactory().getCollectionPersister(this.role);
        return persister.getKeyType().nullSafeGet(rs, name, session, owner);
    }

    public Object resolveIdentifier(Object value, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            return null;
        }
        return this.getCollection((Serializable)value, session);
    }

    public boolean isArrayType() {
        return false;
    }
}

