/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools.reflect;

import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.tools.reflect.MappingByReflection;
import cirrus.hibernate.tools.reflect.ReflectedProperty;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ReflectedClass {
    private MappingByReflection map;
    private StringBuffer buf;
    private Class clazz;
    private Vector subs;
    private Hashtable props;
    private ReflectedProperty uid;
    private boolean persistent;
    private Hashtable setprops;
    private Hashtable getprops;

    protected ReflectedClass(MappingByReflection map, Class cls) {
        this.clazz = cls;
        this.map = map;
        this.subs = new Vector();
        this.uid = null;
        this.persistent = false;
        map.rClasses.put(cls, this);
        this.reflect();
    }

    public String getName() {
        return this.clazz.getName();
    }

    public ReflectedProperty[] getProperties() {
        ReflectedProperty[] rp = new ReflectedProperty[this.props.size()];
        Enumeration e = this.props.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            rp[i++] = (ReflectedProperty)e.nextElement();
        }
        return rp;
    }

    public ReflectedClass[] getSubclasses() {
        Object[] v = new ReflectedClass[this.subs.size()];
        this.subs.copyInto(v);
        return v;
    }

    protected void addReflectedClass(ReflectedClass rc) {
        this.subs.add(rc);
    }

    protected boolean isPersistent() {
        return this.persistent;
    }

    protected void setPersistent(boolean p) {
        this.persistent = p;
    }

    protected boolean hasProperties() {
        return this.props.size() != 0;
    }

    protected void addSuperclassProps() {
        this.addSuperclassProps(this.clazz.getSuperclass());
    }

    private void addSuperclassProps(Class supz) {
        if (supz != null) {
            this.reflectClass(supz);
            this.addSuperclassProps(supz.getSuperclass());
        }
    }

    protected void getXML(int level) {
        this.buf = this.map.buf;
        String name = this.clazz.getName();
        String shortName = StringHelper.unqualify(name);
        this.map.emitPrefix(level);
        this.buf.append("<!-- ").append(name).append(" root -->\n");
        this.map.emitPrefix(level);
        this.buf.append("<class name=\"").append(name).append("\" table=\"").append(this.map.tableNameFor(name)).append(this.subs.size() > 0 ? "\" discriminator-value=\"" + shortName : "").append("\">\n");
        if (this.uid == null) {
            this.map.emitPrefix(level);
            this.buf.append("<!-- NO UID!? class=\"").append(name).append("\" -->\n");
        } else {
            this.uid.getUidXML(level + 1, this.buf);
        }
        if (this.subs.size() > 0) {
            this.map.emitPrefix(level + 1);
            this.buf.append("<discriminator column=\"subclass\" type=\"string\"/>\n");
        }
        Enumeration ps = this.props.elements();
        while (ps.hasMoreElements()) {
            ReflectedProperty prop = (ReflectedProperty)ps.nextElement();
            if (prop.isUid) continue;
            this.map.cycleBuster = new Hashtable();
            prop.getXML(level + 1, this.buf);
        }
        int len = this.subs.size();
        int i = 0;
        while (i < len) {
            ReflectedClass rsc = (ReflectedClass)this.subs.get(i);
            rsc.getXMLasSubclass(level + 1);
            ++i;
        }
        this.map.emitPrefix(level);
        this.buf.append("</class>\n");
    }

    protected void getXMLasSubclass(int level) {
        this.buf = this.map.buf;
        String name = this.clazz.getName();
        this.map.emitPrefix(level);
        this.buf.append("<!-- ").append(name).append(" -->\n");
        this.map.emitPrefix(level);
        this.buf.append("<subclass name=\"").append(name).append("\">\n");
        Enumeration ps = this.props.elements();
        while (ps.hasMoreElements()) {
            ReflectedProperty prop = (ReflectedProperty)ps.nextElement();
            if (prop.isUid) continue;
            prop.getXML(level + 1, this.buf);
        }
        int len = this.subs.size();
        int i = 0;
        while (i < len) {
            ReflectedClass rsc = (ReflectedClass)this.subs.get(i);
            rsc.getXMLasSubclass(level + 1);
            ++i;
        }
        this.map.emitPrefix(level);
        this.buf.append("</subclass>\n");
    }

    protected void getXMLasComponent(int level, String propName) {
        this.buf = this.map.buf;
        String name = this.clazz.getName();
        this.map.emitPrefix(level);
        this.buf.append("<component name=\"").append(propName).append("\" class=\"").append(name).append("\">\n");
        Enumeration ps = this.props.elements();
        while (ps.hasMoreElements()) {
            ReflectedProperty prop = (ReflectedProperty)ps.nextElement();
            prop.getXML(level + 1, this.buf);
        }
        this.map.emitPrefix(level);
        this.buf.append("</component>\n");
    }

    protected void getXMLasComposite(int level) {
        this.buf = this.map.buf;
        String name = this.clazz.getName();
        this.map.emitPrefix(level);
        this.buf.append("<composite-element class=\"").append(name).append("\">\n");
        Enumeration ps = this.props.elements();
        while (ps.hasMoreElements()) {
            ReflectedProperty prop = (ReflectedProperty)ps.nextElement();
            prop.getXMLinComposite(level, this.buf);
        }
        this.map.emitPrefix(level);
        this.buf.append("</composite-element>\n");
    }

    protected void getXMLasMany2Many(int level) {
        this.buf = this.map.buf;
        String name = this.clazz.getName();
        this.map.emitPrefix(level);
        this.buf.append("<many-to-many class=\"").append(name).append("\" column=\"").append(this.map.columnNameFor(name)).append("\"/>\n");
    }

    private String capitalize(String s) {
        char c = s.charAt(0);
        if (Character.isUpperCase(c)) {
            return s;
        }
        char[] ca = new char[]{Character.toUpperCase(c)};
        return new String(ca).concat(s.substring(1));
    }

    protected ReflectedProperty getUidProp(String[] niceKeys) {
        if (this.uid != null) {
            return this.uid;
        }
        int i = 0;
        while (i < niceKeys.length) {
            ReflectedProperty p = (ReflectedProperty)this.props.get(niceKeys[i]);
            if (p != null && p.isUidOK()) {
                this.uid = p;
                break;
            }
            ++i;
        }
        return this.uid;
    }

    private void maybeAddProp(String name, Class type, Hashtable thisprops, Hashtable thatprops) {
        Object ty = thatprops.get(name);
        if (ty == type) {
            thatprops.remove(name);
            ReflectedProperty prop = this.map.makeProperty(name, type);
            if (prop != null) {
                this.props.put(name, prop);
            }
        } else {
            thisprops.put(name, type);
        }
    }

    private void addSetter(String name, Class type) {
        this.maybeAddProp(name, type, this.setprops, this.getprops);
    }

    private void addGetter(String name, Class type) {
        this.maybeAddProp(name, type, this.getprops, this.setprops);
    }

    private void reflect() {
        this.props = new Hashtable();
        this.setprops = new Hashtable();
        this.getprops = new Hashtable();
        this.reflectClass(this.clazz);
    }

    private void reflectClass(Class cls) {
        try {
            Method[] ms = cls.getDeclaredMethods();
            int i = 0;
            while (i < ms.length) {
                Class<?>[] argtyp;
                int mmod;
                Method m = ms[i];
                if (m != null && !Modifier.isStatic(mmod = m.getModifiers()) && (argtyp = m.getParameterTypes()).length <= 1) {
                    String name = m.getName();
                    Class<?> restyp = m.getReturnType();
                    if (argtyp.length == 1) {
                        if (restyp == Void.TYPE && name.startsWith("set")) {
                            this.addSetter(Introspector.decapitalize(name.substring(3)), argtyp[0]);
                        }
                    } else if (name.startsWith("get")) {
                        this.addGetter(Introspector.decapitalize(name.substring(3)), restyp);
                    } else if (restyp == Boolean.TYPE && name.startsWith("is")) {
                        this.addGetter(Introspector.decapitalize(name.substring(2)), restyp);
                    }
                }
                ++i;
            }
        }
        catch (SecurityException e) {}
    }
}

