/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools;

import cirrus.hibernate.Datastore;
import cirrus.hibernate.Environment;
import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProviderFactory;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.sql.Dialect;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class SchemaExport {
    private String[] dropSQL;
    private String[] createSQL;
    private Properties connectionProperties;
    private String outputFile = null;

    public SchemaExport(Datastore ds) throws HibernateException {
        this.connectionProperties = Environment.getProperties();
        Dialect dialect = Dialect.getDialect();
        this.dropSQL = ds.generateDropSchemaScript(dialect);
        this.createSQL = ds.generateSchemaCreationScript(dialect);
    }

    public SchemaExport(Datastore ds, Properties connectionProperties) throws HibernateException {
        this.connectionProperties = connectionProperties;
        Dialect dialect = Dialect.getDialect(connectionProperties);
        this.dropSQL = ds.generateDropSchemaScript(dialect);
        this.createSQL = ds.generateSchemaCreationScript(dialect);
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public void create(boolean script, boolean export) throws HibernateException {
        this.execute(script, export, false, true, null);
    }

    public void drop(boolean script, boolean export) throws HibernateException {
        this.execute(script, export, true, true, null);
    }

    private void execute(boolean script, boolean export, boolean justDrop, boolean format, String delimiter) throws HibernateException {
        Connection connection = null;
        FileWriter fileOutput = null;
        ConnectionProvider cp = null;
        Statement stmt = null;
        Properties givenProps = this.connectionProperties == null ? Environment.getProperties() : this.connectionProperties;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)Dialect.getDialect(givenProps).getDefaultProperties());
        props.putAll((Map<?, ?>)givenProps);
        boolean jdbc2 = false;
        try {
            if (this.outputFile != null) {
                fileOutput = new FileWriter(this.outputFile);
            }
            if (export) {
                cp = ConnectionProviderFactory.newConnectionProvider(props);
                connection = cp.getConnection();
                connection.commit();
                connection.setAutoCommit(true);
                stmt = connection.createStatement();
            }
            int i = 0;
            while (i < this.dropSQL.length) {
                try {
                    String formatted = this.dropSQL[i];
                    if (delimiter != null) {
                        formatted = formatted + delimiter;
                    }
                    if (script) {
                        System.out.println(formatted);
                    }
                    if (this.outputFile != null) {
                        fileOutput.write(formatted + "\n");
                    }
                    if (export) {
                        if (jdbc2) {
                            stmt.addBatch(this.dropSQL[i]);
                        } else {
                            stmt.executeUpdate(this.dropSQL[i]);
                        }
                    }
                }
                catch (SQLException e) {
                    if (!script) {
                        System.out.println(this.dropSQL[i]);
                    }
                    System.out.println("Unsuccessful: " + e.getMessage());
                }
                ++i;
            }
            if (!justDrop) {
                int j = 0;
                while (j < this.createSQL.length) {
                    try {
                        String formatted;
                        String string = formatted = format ? SchemaExport.format(this.createSQL[j], delimiter) : this.createSQL[j];
                        if (script) {
                            System.out.println(formatted);
                        }
                        if (this.outputFile != null) {
                            fileOutput.write(formatted + "\n");
                        }
                        if (export) {
                            if (jdbc2) {
                                stmt.addBatch(this.createSQL[j]);
                            } else {
                                stmt.executeUpdate(this.createSQL[j]);
                            }
                        }
                    }
                    catch (SQLException e) {
                        if (!script) {
                            System.out.println(this.createSQL[j]);
                        }
                        System.out.println("Unsuccessful: " + e.getMessage());
                    }
                    ++j;
                }
            }
            if (jdbc2) {
                stmt.executeBatch();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HibernateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    JDBCExceptionReporter.logWarnings(connection.getWarnings());
                    connection.clearWarnings();
                    cp.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                System.err.println("Could not close connection: " + e.getMessage());
            }
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (IOException ioe) {
                    System.err.println("Error closing output file " + this.outputFile + ": " + ioe.getMessage());
                }
            }
        }
    }

    private static String format(String sql, String delimiter) {
        String formatted;
        if (sql.indexOf("\"") > 0 || sql.indexOf("'") > 0) {
            return sql;
        }
        if (sql.toLowerCase().startsWith("create table")) {
            StringBuffer result = new StringBuffer(60);
            StringTokenizer tokens = new StringTokenizer(sql, "(,)", true);
            int depth = 0;
            while (tokens.hasMoreTokens()) {
                String tok = tokens.nextToken();
                if (")".equals(tok) && --depth == 0) {
                    result.append("\n");
                }
                result.append(tok);
                if (",".equals(tok) && depth == 1) {
                    result.append("\n  ");
                }
                if (!"(".equals(tok) || ++depth != 1) continue;
                result.append("\n   ");
            }
            formatted = result.toString();
        } else {
            formatted = sql;
        }
        return delimiter != null ? formatted + delimiter : formatted;
    }

    public static void main(String[] args) {
        block21: {
            try {
                Datastore ds = Hibernate.createDatastore();
                boolean script = true;
                boolean drop = false;
                boolean export = true;
                String outputFile = null;
                String propFile = null;
                boolean formatSQL = false;
                String delimiter = null;
                int i = 0;
                while (i < args.length) {
                    if (args[i].startsWith("--")) {
                        if (args[i].equals("--quiet")) {
                            script = false;
                        } else if (args[i].equals("--drop")) {
                            drop = true;
                        } else if (args[i].equals("--text")) {
                            export = false;
                        } else if (args[i].startsWith("--output=")) {
                            outputFile = args[i].substring(9);
                        } else if (args[i].startsWith("--properties=")) {
                            propFile = args[i].substring(13);
                        } else if (args[i].equals("--format")) {
                            formatSQL = true;
                        } else if (args[i].startsWith("--delimiter=")) {
                            delimiter = args[i].substring(12);
                        }
                    } else {
                        String filename = args[i];
                        if (filename.endsWith(".jar")) {
                            ds.storeJar(filename);
                        } else {
                            ds.storeFile(filename);
                        }
                    }
                    ++i;
                }
                if (propFile != null) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(propFile));
                    new SchemaExport(ds, props).setOutputFile(outputFile).execute(script, export, drop, formatSQL, delimiter);
                    break block21;
                }
                new SchemaExport(ds).setOutputFile(outputFile).execute(script, export, drop, formatSQL, delimiter);
            }
            catch (Exception e) {
                System.err.println("Error creating schema " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

