/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.sql;

import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.sql.Dialect;

public class MySQLDialect
extends Dialect {
    public MySQLDialect() {
        this.register(-7, "BIT");
        this.register(-5, "BIGINT");
        this.register(5, "SMALLINT");
        this.register(-6, "TINYINT");
        this.register(4, "INTEGER");
        this.register(1, "CHAR(1)");
        this.register(12, "LONGTEXT");
        this.register(12, 0xFFFFFF, "MEDIUMTEXT");
        this.register(12, 65535, "TEXT");
        this.register(12, 255, "VARCHAR($l)");
        this.register(6, "FLOAT");
        this.register(8, "DOUBLE PRECISION");
        this.register(91, "DATE");
        this.register(92, "TIME");
        this.register(93, "DATETIME");
        this.register(-3, "LONGBLOB");
        this.register(-3, 0xFFFFFF, "MEDIUMBLOB");
        this.register(-3, 65535, "BLOB");
        this.register(-3, 255, "VARCHAR($l) BINARY");
        this.register(2, "NUMERIC(19, $l)");
        this.register(2004, "LONGBLOB");
        this.register(2004, 0xFFFFFF, "MEDIUMBLOB");
        this.register(2004, 65535, "BLOB");
        this.register(2005, "LONGTEXT");
        this.register(2005, 0xFFFFFF, "MEDIUMTEXT");
        this.register(2005, 65535, "TEXT");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "SELECT LAST_INSERT_ID()";
    }

    public String getIdentityColumnString() {
        return "NOT NULL AUTO_INCREMENT";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        String cols = StringHelper.join(", ", foreignKey);
        return new StringBuffer(30).append(" add index (").append(cols).append("), add constraint ").append(constraintName).append(" foreign key (").append(cols).append(") references ").append(referencedTable).append(" (").append(StringHelper.join(", ", primaryKey)).append(')').toString();
    }
}

