/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.sql;

import cirrus.hibernate.Environment;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.loader.AnsiOuterJoinGenerator;
import cirrus.hibernate.loader.OuterJoinGenerator;
import cirrus.hibernate.sql.TypeNames;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Dialect {
    static final String DEFAULT_BATCH_SIZE = "15";
    static final String NO_BATCH = "0";
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$sql$Dialect == null ? (class$cirrus$hibernate$sql$Dialect = Dialect.class$("cirrus.hibernate.sql.Dialect")) : class$cirrus$hibernate$sql$Dialect));
    private final TypeNames typeNames = new TypeNames("$l");
    private final Properties properties = new Properties();
    private final OuterJoinGenerator outerJoinGenerator = new AnsiOuterJoinGenerator();
    public static final String QUOTE = "`\"";
    static /* synthetic */ Class class$cirrus$hibernate$sql$Dialect;

    protected Dialect() {
        log.info((Object)("Using dialect: " + this));
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        return result;
    }

    public String getTypeName(int code, int length) throws HibernateException {
        String result = this.typeNames.get(code, length);
        if (result == null) {
            throw new HibernateException("No type mapping for (java.sql.Types) " + code + " of length " + length);
        }
        return result;
    }

    protected void register(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void register(int code, String name) {
        this.typeNames.put(code, name);
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsForUpdate() {
        return true;
    }

    public boolean supportsForUpdateNowait() {
        return false;
    }

    public boolean supportsUnique() {
        return true;
    }

    public abstract String getAddColumnString();

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        return new StringBuffer(30).append(" add constraint ").append(constraintName).append(" foreign key (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable).toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public Serializable getIdentityFrom(ResultSet rs) throws SQLException {
        return new Long(rs.getLong(1));
    }

    public String getIdentitySelectString() throws MappingException {
        throw new MappingException("Dialect does not support native key generation");
    }

    public String getIdentityColumnString() throws MappingException {
        throw new MappingException("Dialect does not support native key generation");
    }

    public String getIdentityInsertString() {
        return null;
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getCreateSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getDropSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getQuerySequencesString() {
        return null;
    }

    public static Dialect getDialect() throws HibernateException {
        String dialectName = Environment.getProperties().getProperty("hibernate.dialect");
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public static Dialect getDialect(Properties props) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return Dialect.getDialect();
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public OuterJoinGenerator getOuterJoinGenerator() {
        return this.outerJoinGenerator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

