/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.AbstractPostInsertGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.AbstractSelectingDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertSelectIdentityInsert;
import org.hibernate.util.GetGeneratedKeysHelper;

public class IdentityGenerator
extends AbstractPostInsertGenerator {
    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister persister, Dialect dialect, boolean isGetGeneratedKeysEnabled) throws HibernateException {
        if (isGetGeneratedKeysEnabled) {
            return new GetGeneratedKeysDelegate(persister, dialect);
        }
        if (dialect.supportsInsertSelectIdentity()) {
            return new InsertSelectDelegate(persister, dialect);
        }
        return new BasicDelegate(persister, dialect);
    }

    public static class BasicDelegate
    extends AbstractSelectingDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public BasicDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
            super(persister);
            this.persister = persister;
            this.dialect = dialect;
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            IdentifierGeneratingInsert insert = new IdentifierGeneratingInsert(this.dialect);
            insert.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return insert;
        }

        protected String getSelectSQL() {
            return this.persister.getIdentitySelectString();
        }

        protected Serializable getResult(SessionImplementor session, ResultSet rs, Object object) throws SQLException {
            return IdentifierGeneratorFactory.getGeneratedIdentity(rs, this.persister.getIdentifierType());
        }
    }

    public static class InsertSelectDelegate
    extends AbstractReturningDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public InsertSelectDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
            super(persister);
            this.persister = persister;
            this.dialect = dialect;
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            InsertSelectIdentityInsert insert = new InsertSelectIdentityInsert(this.dialect);
            insert.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return insert;
        }

        protected PreparedStatement prepare(String insertSQL, SessionImplementor session) throws SQLException {
            return session.getBatcher().prepareStatement(insertSQL, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable executeAndExtract(PreparedStatement insert) throws SQLException {
            Serializable serializable;
            if (!insert.execute()) {
                while (!insert.getMoreResults() && insert.getUpdateCount() != -1) {
                }
            }
            ResultSet rs = insert.getResultSet();
            try {
                serializable = IdentifierGeneratorFactory.getGeneratedIdentity(rs, this.persister.getIdentifierType());
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            return serializable;
        }

        public Serializable determineGeneratedIdentifier(SessionImplementor session, Object entity) {
            throw new AssertionFailure("insert statement returns generated value");
        }
    }

    public static class GetGeneratedKeysDelegate
    extends AbstractReturningDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public GetGeneratedKeysDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
            super(persister);
            this.persister = persister;
            this.dialect = dialect;
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            IdentifierGeneratingInsert insert = new IdentifierGeneratingInsert(this.dialect);
            insert.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return insert;
        }

        protected PreparedStatement prepare(String insertSQL, SessionImplementor session) throws SQLException {
            return session.getBatcher().prepareStatement(insertSQL, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable executeAndExtract(PreparedStatement insert) throws SQLException {
            Serializable serializable;
            block2: {
                insert.executeUpdate();
                ResultSet rs = null;
                try {
                    rs = GetGeneratedKeysHelper.getGeneratedKey(insert);
                    serializable = IdentifierGeneratorFactory.getGeneratedIdentity(rs, this.persister.getIdentifierType());
                    Object var5_4 = null;
                    if (rs == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var5_5 = null;
                        if (rs == null) break block3;
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            return serializable;
        }
    }
}

