/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.util.ArrayList;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.fo.expr.PropertyException;

public class MixedLength
extends Length {
    private ArrayList lengths;

    public MixedLength(ArrayList lengths) {
        this.lengths = lengths;
    }

    protected void computeValue() {
        int computedValue = 0;
        boolean bAllComputed = true;
        for (int i = 0; i < this.lengths.size(); ++i) {
            Length l = (Length)this.lengths.get(i);
            computedValue += l.mvalue();
            if (l.isComputed()) continue;
            bAllComputed = false;
        }
        this.setComputedValue(computedValue, bAllComputed);
    }

    public double getTableUnits() {
        double tableUnits = 0.0;
        for (int i = 0; i < this.lengths.size(); ++i) {
            tableUnits += ((Length)this.lengths.get(i)).getTableUnits();
        }
        return tableUnits;
    }

    public void resolveTableUnit(double dTableUnit) {
        for (int i = 0; i < this.lengths.size(); ++i) {
            ((Length)this.lengths.get(i)).resolveTableUnit(dTableUnit);
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.lengths.size(); ++i) {
            if (sbuf.length() > 0) {
                sbuf.append('+');
            }
            sbuf.append(this.lengths.get(i).toString());
        }
        return sbuf.toString();
    }

    public Numeric asNumeric() {
        Numeric numeric = null;
        for (int i = 0; i < this.lengths.size(); ++i) {
            Length l = (Length)this.lengths.get(i);
            if (numeric == null) {
                numeric = l.asNumeric();
                continue;
            }
            try {
                Numeric sum;
                numeric = sum = numeric.add(l.asNumeric());
                continue;
            }
            catch (PropertyException pe) {
                System.err.println("Can't convert MixedLength to Numeric: " + pe);
            }
        }
        return numeric;
    }
}

