/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.Page;
import org.apache.fop.render.Renderer;
import org.xml.sax.SAXException;

public class StreamRenderer {
    private static final boolean MEM_PROFILE_WITH_GC = false;
    private Runtime runtime = Runtime.getRuntime();
    int pageCount = 0;
    private long initialMemory;
    private long startTime;
    private OutputStream outputStream;
    private Renderer renderer;
    private FormattingResults results = new FormattingResults();
    private FontInfo fontInfo = new FontInfo();
    private ArrayList renderQueue = new ArrayList();
    private IDReferences idReferences = new IDReferences();
    private ArrayList extensions = new ArrayList();
    private ArrayList documentMarkers;
    private ArrayList currentPageSequenceMarkers;
    private PageSequence currentPageSequence;
    private Logger log;

    public StreamRenderer(OutputStream outputStream, Renderer renderer) {
        this.outputStream = outputStream;
        this.renderer = renderer;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public IDReferences getIDReferences() {
        return this.idReferences;
    }

    public FormattingResults getResults() {
        return this.results;
    }

    public void addExtension(ExtensionObj ext) {
        this.extensions.add(ext);
    }

    public void startRenderer() throws SAXException {
        this.pageCount = 0;
        this.initialMemory = this.runtime.totalMemory() - this.runtime.freeMemory();
        this.startTime = System.currentTimeMillis();
        try {
            this.renderer.setupFontInfo(this.fontInfo);
            this.renderer.startRenderer(this.outputStream);
        }
        catch (FOPException fe) {
            throw new SAXException(fe);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void stopRenderer() throws SAXException {
        try {
            this.processQueue(true);
            this.renderer.stopRenderer(this.outputStream);
        }
        catch (FOPException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        long memoryNow = this.runtime.totalMemory() - this.runtime.freeMemory();
        long memoryUsed = (memoryNow - this.initialMemory) / 1024L;
        this.log.debug("Initial heap size: " + this.initialMemory / 1024L + "Kb");
        this.log.debug("Current heap size: " + memoryNow / 1024L + "Kb");
        this.log.debug("Total memory used: " + memoryUsed + "Kb");
        this.log.debug("  Memory use is indicative; no GC was performed");
        this.log.debug("  These figures should not be used comparatively");
        long timeUsed = System.currentTimeMillis() - this.startTime;
        this.log.debug("Total time used: " + timeUsed + "ms");
        this.log.debug("Pages rendered: " + this.pageCount);
        if (this.pageCount != 0) {
            this.log.debug("Avg render time: " + timeUsed / (long)this.pageCount + "ms/page");
        }
    }

    public void render(PageSequence pageSequence) throws SAXException {
        AreaTree a = new AreaTree(this);
        a.setFontInfo(this.fontInfo);
        for (int i = 0; i < this.extensions.size(); ++i) {
            ExtensionObj ext = (ExtensionObj)this.extensions.get(i);
            try {
                ext.format(a);
                continue;
            }
            catch (FOPException fope) {
                throw new SAXException(fope);
            }
        }
        try {
            pageSequence.format(a);
        }
        catch (FOPException e) {
            throw new SAXException(e);
        }
        this.results.haveFormattedPageSequence(pageSequence);
        this.log.debug("Last page-sequence produced " + pageSequence.getPageCount() + " pages.");
    }

    public synchronized void queuePage(Page page) throws FOPException, IOException {
        ArrayList markers;
        PageSequence pageSequence = page.getPageSequence();
        if (pageSequence != this.currentPageSequence) {
            this.currentPageSequence = pageSequence;
            this.currentPageSequenceMarkers = null;
        }
        if ((markers = page.getMarkers()) != null) {
            if (this.documentMarkers == null) {
                this.documentMarkers = new ArrayList();
            }
            if (this.currentPageSequenceMarkers == null) {
                this.currentPageSequenceMarkers = new ArrayList();
            }
            for (int i = 0; i < markers.size(); ++i) {
                Marker marker = (Marker)markers.get(i);
                marker.releaseRegistryArea();
                this.currentPageSequenceMarkers.add(marker);
                this.documentMarkers.add(marker);
            }
        }
        if (this.renderQueue.size() == 0 && this.idReferences.isEveryIdValid()) {
            this.renderer.render(page, this.outputStream);
        } else {
            RenderQueueEntry entry = new RenderQueueEntry(page);
            this.renderQueue.add(entry);
            this.processQueue(false);
        }
        ++this.pageCount;
    }

    private synchronized void processQueue(boolean force) throws FOPException, IOException {
        while (this.renderQueue.size() > 0) {
            RenderQueueEntry entry = (RenderQueueEntry)this.renderQueue.get(0);
            if (!force && !entry.isResolved()) break;
            this.renderer.render(entry.getPage(), this.outputStream);
            this.renderQueue.remove(0);
        }
    }

    public ArrayList getDocumentMarkers() {
        return this.documentMarkers;
    }

    public PageSequence getCurrentPageSequence() {
        return this.currentPageSequence;
    }

    public ArrayList getCurrentPageSequenceMarkers() {
        return this.currentPageSequenceMarkers;
    }

    class RenderQueueEntry {
        private Page page;
        private ArrayList unresolvedIdReferences = new ArrayList();

        public RenderQueueEntry(Page page) {
            this.page = page;
            Iterator e = StreamRenderer.this.idReferences.getInvalidElements();
            while (e.hasNext()) {
                this.unresolvedIdReferences.add(e.next());
            }
        }

        public Page getPage() {
            return this.page;
        }

        public boolean isResolved() {
            if (this.unresolvedIdReferences.size() == 0 || StreamRenderer.this.idReferences.isEveryIdValid()) {
                return true;
            }
            for (int i = 0; i < this.unresolvedIdReferences.size(); ++i) {
                if (StreamRenderer.this.idReferences.doesIDExist((String)this.unresolvedIdReferences.get(i))) continue;
                return false;
            }
            this.unresolvedIdReferences.clear();
            return true;
        }
    }
}

