/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class FD_SOCK
extends Protocol
implements Runnable {
    long get_cache_timeout = 3000L;
    static final long get_cache_retry_timeout = 500L;
    long suspect_msg_interval = 5000L;
    int num_tries = 3;
    final Vector members = new Vector(11);
    boolean srv_sock_sent = false;
    final Vector pingable_mbrs = new Vector(11);
    final Promise get_cache_promise = new Promise();
    boolean got_cache_from_coord = false;
    Address local_addr = null;
    ServerSocket srv_sock = null;
    InetAddress bind_addr = null;
    String group_name = null;
    InetAddress srv_sock_bind_addr = null;
    private ServerSocketHandler srv_sock_handler = null;
    IpAddress srv_sock_addr = null;
    Address ping_dest = null;
    Socket ping_sock = null;
    InputStream ping_input = null;
    Thread pinger_thread = null;
    final Object pinger_mutex = new Object();
    final Hashtable cache = new Hashtable(11);
    int start_port = 0;
    final Promise ping_addr_promise = new Promise();
    final Object sock_mutex = new Object();
    TimeScheduler timer = null;
    private final BroadcastTask bcast_task = new BroadcastTask();
    boolean regular_sock_close = false;
    int num_suspect_events = 0;
    private static final int INTERRUPT = 8;
    private static final int NORMAL_TERMINATION = 9;
    private static final int ABNORMAL_TERMINATION = -1;
    private static final String name = "FD_SOCK";
    BoundedList suspect_history = new BoundedList(20);
    private boolean keep_alive = true;
    private boolean running = false;
    private int sock_conn_timeout = 1000;
    static /* synthetic */ Class class$org$jgroups$stack$IpAddress;

    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public String printSuspectHistory() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.suspect_history.elements();
        while (en.hasMoreElements()) {
            sb.append(new Date()).append(": ").append(en.nextElement()).append("\n");
        }
        return sb.toString();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("get_cache_timeout");
        if (str != null) {
            this.get_cache_timeout = Long.parseLong(str);
            props.remove("get_cache_timeout");
        }
        if ((str = props.getProperty("suspect_msg_interval")) != null) {
            this.suspect_msg_interval = Long.parseLong(str);
            props.remove("suspect_msg_interval");
        }
        if ((str = props.getProperty("num_tries")) != null) {
            this.num_tries = Integer.parseInt(str);
            props.remove("num_tries");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.start_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("keep_alive")) != null) {
            this.keep_alive = Boolean.valueOf(str);
            props.remove("keep_alive");
        }
        if ((str = props.getProperty("srv_sock_bind_addr")) != null) {
            this.log.error((Object)"srv_sock_bind_addr is deprecated and will be ignored - use bind_addr instead");
            props.remove("srv_sock_bind_addr");
        }
        if ((str = props.getProperty("sock_conn_timeout")) != null) {
            this.sock_conn_timeout = Integer.parseInt(str);
            props.remove("sock_conn_timeout");
        }
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                this.log.error((Object)("(bind_addr): host " + str + " not known"));
                return false;
            }
            props.remove("bind_addr");
        }
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.srv_sock_handler = new ServerSocketHandler();
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("FD_SOCK.init(): timer == null");
        }
    }

    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.bcast_task.removeAll();
        this.stopPingerThread();
        this.stopServerSocket();
    }

    public void resetStats() {
        super.resetStats();
        this.num_suspect_events = 0;
        this.suspect_history.removeAll();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                FdHeader hdr = (FdHeader)msg.removeHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 10: {
                        if (hdr.mbrs != null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("[SUSPECT] hdr=" + hdr));
                            }
                            for (int i = 0; i < hdr.mbrs.size(); ++i) {
                                Address m = (Address)hdr.mbrs.elementAt(i);
                                if (this.local_addr != null && m.equals(this.local_addr)) {
                                    if (!this.log.isWarnEnabled()) continue;
                                    this.log.warn((Object)("I was suspected by " + msg.getSrc() + "; ignoring the SUSPECT message"));
                                    continue;
                                }
                                this.passUp(new Event(9, hdr.mbrs.elementAt(i)));
                                this.passDown(new Event(9, hdr.mbrs.elementAt(i)));
                            }
                            break;
                        }
                        if (!this.log.isWarnEnabled()) break;
                        this.log.warn((Object)"[SUSPECT]: hdr.mbrs == null");
                        break;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return;
                        }
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"hdr.mbr is null");
                            }
                            return;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("who-has-sock " + hdr.mbr));
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(msg.getSrc(), this.local_addr, this.srv_sock_addr);
                            return;
                        }
                        if (!this.cache.containsKey(hdr.mbr)) break;
                        this.sendIHaveSockMessage(msg.getSrc(), hdr.mbr, (IpAddress)this.cache.get(hdr.mbr));
                        break;
                    }
                    case 12: {
                        if (hdr.mbr == null || hdr.sock_addr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"[I_HAVE_SOCK]: hdr.mbr is null or hdr.sock_addr == null");
                            }
                            return;
                        }
                        this.cache.put(hdr.mbr, hdr.sock_addr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("i-have-sock: " + hdr.mbr + " --> " + hdr.sock_addr + " (cache is " + this.cache + ')'));
                        }
                        if (this.ping_dest == null || !hdr.mbr.equals(this.ping_dest)) break;
                        this.ping_addr_promise.setResult(hdr.sock_addr);
                        break;
                    }
                    case 13: {
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"(GET_CACHE): hdr.mbr == null");
                            }
                            return;
                        }
                        hdr = new FdHeader(14);
                        hdr.cachedAddrs = (Hashtable)this.cache.clone();
                        msg = new Message(hdr.mbr, null, null);
                        msg.putHeader(name, hdr);
                        this.passDown(new Event(1, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.cachedAddrs == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"(GET_CACHE_RSP): cache is null");
                            }
                            return;
                        }
                        this.get_cache_promise.setResult(hdr.cachedAddrs);
                    }
                }
                return;
            }
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 51: {
                this.bcast_task.removeSuspectedMember((Address)evt.getArg());
                break;
            }
            case 2: {
                this.passDown(evt);
                this.group_name = (String)evt.getArg();
                this.srv_sock = Util.createServerSocket(this.bind_addr, this.start_port);
                this.srv_sock_addr = new IpAddress(this.bind_addr, this.srv_sock.getLocalPort());
                this.startServerSocket();
                break;
            }
            case 4: {
                int index;
                String tmp;
                this.group_name = null;
                String prefix = " (channel=";
                String string = tmp = this.srv_sock_handler != null ? this.srv_sock_handler.getName() : null;
                if (tmp != null && (index = tmp.indexOf(prefix)) > -1) {
                    tmp = tmp.substring(0, index);
                    this.srv_sock_handler.setName(tmp);
                }
                Object object = this.pinger_mutex;
                synchronized (object) {
                    String string2 = tmp = this.pinger_thread != null ? this.pinger_thread.getName() : null;
                    if (tmp != null && (index = tmp.indexOf(prefix)) > -1) {
                        tmp = tmp.substring(0, index);
                        this.pinger_thread.setName(tmp);
                    }
                }
                this.stopServerSocket();
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                Vector new_mbrs = v.getMembers();
                this.passDown(evt);
                FD_SOCK fD_SOCK = this;
                synchronized (fD_SOCK) {
                    this.members.removeAllElements();
                    this.members.addAll(new_mbrs);
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.removeAllElements();
                    this.pingable_mbrs.addAll(this.members);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("VIEW_CHANGE received: " + this.members));
                    }
                    if (!this.got_cache_from_coord) {
                        this.getCacheFromCoordinator();
                        this.got_cache_from_coord = true;
                    }
                    if (!this.srv_sock_sent) {
                        if (this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
                            this.srv_sock_sent = true;
                        } else if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"(VIEW_CHANGE): srv_sock_addr == null");
                        }
                    }
                    Enumeration e = this.cache.keys();
                    while (e.hasMoreElements()) {
                        Address mbr = (Address)e.nextElement();
                        if (this.members.contains(mbr)) continue;
                        this.cache.remove(mbr);
                    }
                    if (this.members.size() > 1) {
                        Object object = this.pinger_mutex;
                        synchronized (object) {
                            if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
                                Address tmp_ping_dest = this.determinePingDest();
                                if (this.ping_dest != null && tmp_ping_dest != null && !this.ping_dest.equals(tmp_ping_dest)) {
                                    this.interruptPingerThread();
                                }
                            } else {
                                this.startPingerThread();
                            }
                        }
                    } else {
                        this.ping_dest = null;
                        this.stopPingerThread();
                    }
                    break;
                }
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int max_fetch_tries = 10;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"pinger_thread started");
        }
        while (this.pinger_thread != null && Thread.currentThread().equals(this.pinger_thread) && this.running) {
            Address tmp_ping_dest = this.determinePingDest();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("determinePingDest()=" + tmp_ping_dest + ", pingable_mbrs=" + this.pingable_mbrs));
            }
            if (tmp_ping_dest == null) {
                this.ping_dest = null;
                Object object = this.pinger_mutex;
                synchronized (object) {
                    this.pinger_thread = null;
                    break;
                }
            }
            this.ping_dest = tmp_ping_dest;
            IpAddress ping_addr = this.fetchPingAddress(this.ping_dest);
            if (ping_addr == null) {
                if (!this.running) break;
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("socket address for " + this.ping_dest + " could not be fetched, retrying"));
                }
                if (--max_fetch_tries <= 0) break;
                Util.sleep(2000L);
                continue;
            }
            if (!this.setupPingSocket(ping_addr)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("could not create socket to " + this.ping_dest + "; suspecting " + this.ping_dest));
                }
                this.broadcastSuspectMessage(this.ping_dest);
                this.pingable_mbrs.removeElement(this.ping_dest);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ping_dest=" + this.ping_dest + ", ping_sock=" + this.ping_sock + ", cache=" + this.cache));
            }
            try {
                if (this.ping_input == null) continue;
                int c = this.ping_input.read();
                switch (c) {
                    case 9: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"peer closed socket normally");
                        }
                        Object object = this.pinger_mutex;
                        synchronized (object) {
                            this.pinger_thread = null;
                            break;
                        }
                    }
                    case -1: {
                        this.handleSocketClose(null);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.handleSocketClose(ex);
            }
            catch (Throwable catch_all_the_rest) {
                this.log.error((Object)"exception", catch_all_the_rest);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"pinger thread terminated");
        }
        Object object = this.pinger_mutex;
        synchronized (object) {
            this.pinger_thread = null;
        }
    }

    void handleSocketClose(Exception ex) {
        this.teardownPingSocket();
        if (!this.regular_sock_close) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("peer " + this.ping_dest + " closed socket (" + (ex != null ? ex.getClass().getName() : "eof") + ')'));
            }
            this.broadcastSuspectMessage(this.ping_dest);
            this.pingable_mbrs.removeElement(this.ping_dest);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("socket to " + this.ping_dest + " was reset"));
            }
            this.regular_sock_close = false;
        }
    }

    void startPingerThread() {
        this.running = true;
        if (this.pinger_thread == null) {
            this.pinger_thread = new Thread(Util.getGlobalThreadGroup(), this, "FD_SOCK Ping thread");
            this.pinger_thread.setDaemon(true);
            this.pinger_thread.start();
            if (this.group_name != null) {
                String prefix = " (channel=";
                String tmp = this.pinger_thread.getName();
                if (tmp != null && tmp.indexOf(prefix) == -1) {
                    tmp = tmp + prefix + this.group_name + ")";
                    this.pinger_thread.setName(tmp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPingerThread() {
        this.running = false;
        Object object = this.pinger_mutex;
        synchronized (object) {
            if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
                this.regular_sock_close = true;
                this.pinger_thread = null;
                this.sendPingTermination();
                this.teardownPingSocket();
                this.ping_addr_promise.setResult(null);
            }
        }
    }

    synchronized void sendPingTermination() {
        this.sendPingSignal(9);
    }

    void sendPingInterrupt() {
        this.sendPingSignal(8);
    }

    synchronized void sendPingSignal(int signal) {
        block4: {
            if (this.ping_sock != null) {
                try {
                    OutputStream out = this.ping_sock.getOutputStream();
                    if (out != null) {
                        out.write(signal);
                        out.flush();
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isTraceEnabled()) break block4;
                    this.log.trace((Object)("problem sending signal " + FD_SOCK.signalToString(signal)), t);
                }
            }
        }
    }

    void interruptPingerThread() {
        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
            this.regular_sock_close = true;
            this.sendPingInterrupt();
            this.teardownPingSocket();
        }
    }

    void startServerSocket() {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.start();
            if (this.group_name != null) {
                String prefix = " (channel=";
                String tmp = this.srv_sock_handler.getName();
                if (tmp != null && tmp.indexOf(prefix) == -1) {
                    tmp = tmp + prefix + this.group_name + ")";
                    this.srv_sock_handler.setName(tmp);
                }
            }
        }
    }

    void stopServerSocket() {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setupPingSocket(IpAddress dest) {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (dest == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"destination address is null");
                }
                return false;
            }
            try {
                InetSocketAddress destAddr = new InetSocketAddress(dest.getIpAddress(), dest.getPort());
                this.ping_sock = new Socket();
                this.ping_sock.setSoLinger(true, 1);
                this.ping_sock.setKeepAlive(this.keep_alive);
                this.ping_sock.connect(destAddr, this.sock_conn_timeout);
                this.ping_input = this.ping_sock.getInputStream();
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void teardownPingSocket() {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (this.ping_sock != null) {
                try {
                    this.ping_sock.shutdownInput();
                    this.ping_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ping_sock = null;
            }
            Util.close(this.ping_input);
            this.ping_input = null;
        }
    }

    void getCacheFromCoordinator() {
        this.get_cache_promise.reset();
        for (int attempts = this.num_tries; attempts > 0; --attempts) {
            Address coord = this.determineCoordinator();
            if (coord != null) {
                if (coord.equals(this.local_addr)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"first member; cache is empty");
                    }
                    return;
                }
                FdHeader hdr = new FdHeader(13);
                hdr.mbr = this.local_addr;
                Message msg = new Message(coord, null, null);
                msg.putHeader(name, hdr);
                this.passDown(new Event(1, msg));
                Hashtable result = (Hashtable)this.get_cache_promise.getResult(this.get_cache_timeout);
                if (result != null) {
                    this.cache.putAll(result);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("got cache from " + coord + ": cache is " + this.cache));
                    }
                    return;
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"received null cache; retrying");
                }
            }
            Util.sleep(500L);
        }
    }

    void broadcastSuspectMessage(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("suspecting " + suspected_mbr + " (own address is " + this.local_addr + ')'));
        }
        FdHeader hdr = new FdHeader(10);
        hdr.mbrs = new Vector(1);
        hdr.mbrs.addElement(suspected_mbr);
        Message suspect_msg = new Message();
        suspect_msg.putHeader(name, hdr);
        this.passDown(new Event(1, suspect_msg));
        this.bcast_task.addSuspectedMember(suspected_mbr);
        if (this.stats) {
            ++this.num_suspect_events;
            this.suspect_history.add(suspected_mbr);
        }
    }

    void broadcastWhoHasSockMessage(Address mbr) {
        if (this.local_addr != null && mbr != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("[" + this.local_addr + "]: who-has " + mbr));
        }
        Message msg = new Message();
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        msg.putHeader(name, hdr);
        this.passDown(new Event(1, msg));
    }

    void sendIHaveSockMessage(Address dst, Address mbr, IpAddress addr) {
        Message msg = new Message(dst, null, null);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.sock_addr = addr;
        msg.putHeader(name, hdr);
        this.passDown(new Event(1, msg));
    }

    private IpAddress fetchPingAddress(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"mbr == null");
            }
            return null;
        }
        IpAddress ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        Util.sleep(300L);
        ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        this.ping_addr_promise.reset();
        Message ping_addr_req = new Message(mbr, null, null);
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(name, hdr);
        this.passDown(new Event(1, ping_addr_req));
        if (!this.running) {
            return null;
        }
        ret = (IpAddress)this.ping_addr_promise.getResult(3000L);
        if (ret != null) {
            return ret;
        }
        ping_addr_req = new Message(null);
        hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(name, hdr);
        this.passDown(new Event(1, ping_addr_req));
        ret = (IpAddress)this.ping_addr_promise.getResult(3000L);
        return ret;
    }

    Address determinePingDest() {
        if (this.pingable_mbrs == null || this.pingable_mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < this.pingable_mbrs.size(); ++i) {
            Address tmp = (Address)this.pingable_mbrs.elementAt(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= this.pingable_mbrs.size()) {
                return (Address)this.pingable_mbrs.elementAt(0);
            }
            return (Address)this.pingable_mbrs.elementAt(i + 1);
        }
        return null;
    }

    Address determineCoordinator() {
        return this.members.size() > 0 ? (Address)this.members.elementAt(0) : null;
    }

    static String signalToString(int signal) {
        switch (signal) {
            case 9: {
                return "NORMAL_TERMINATION";
            }
            case -1: {
                return "ABNORMAL_TERMINATION";
            }
            case 8: {
                return "INTERRUPT";
            }
        }
        return "n/a";
    }

    private class BroadcastTask
    implements TimeScheduler.Task {
        final Vector suspected_mbrs = new Vector(7);
        boolean stopped = false;

        private BroadcastTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD_SOCK.this.members.contains(mbr)) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    if (FD_SOCK.this.log.isDebugEnabled()) {
                        FD_SOCK.this.log.debug((Object)("mbr=" + mbr + " (size=" + this.suspected_mbrs.size() + ')'));
                    }
                }
                if (this.stopped && this.suspected_mbrs.size() > 0) {
                    this.stopped = false;
                    FD_SOCK.this.timer.add(this, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug((Object)("member is " + suspected_mbr));
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
                this.stopped = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustSuspectedMembers(Vector new_mbrship) {
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                Iterator it = this.suspected_mbrs.iterator();
                while (it.hasNext()) {
                    Address suspected_mbr = (Address)it.next();
                    if (new_mbrship.contains(suspected_mbr)) continue;
                    it.remove();
                    if (!FD_SOCK.this.log.isDebugEnabled()) continue;
                    FD_SOCK.this.log.debug((Object)("removed " + suspected_mbr + " (size=" + this.suspected_mbrs.size() + ')'));
                }
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
            }
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return FD_SOCK.this.suspect_msg_interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FdHeader hdr;
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug((Object)("broadcasting SUSPECT message (suspected_mbrs=" + this.suspected_mbrs + ") to group"));
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                    if (FD_SOCK.this.log.isDebugEnabled()) {
                        FD_SOCK.this.log.debug((Object)"task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(10);
                hdr.mbrs = (Vector)this.suspected_mbrs.clone();
            }
            Message suspect_msg = new Message();
            suspect_msg.putHeader(FD_SOCK.name, hdr);
            FD_SOCK.this.passDown(new Event(1, suspect_msg));
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug((Object)"task done");
            }
        }
    }

    private static class ClientConnectionHandler
    extends Thread {
        Socket client_sock = null;
        InputStream in;
        final Object mutex = new Object();
        final List clients = new ArrayList();

        ClientConnectionHandler(Socket client_sock, List clients) {
            this.setName("ClientConnectionHandler");
            this.setDaemon(true);
            this.client_sock = client_sock;
            this.clients.addAll(clients);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.client_sock != null) {
                    try {
                        OutputStream out = this.client_sock.getOutputStream();
                        out.write(9);
                        out.flush();
                        this.closeClientSocket();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeClientSocket() {
            Object object = this.mutex;
            synchronized (object) {
                Util.close(this.client_sock);
                this.client_sock = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.mutex;
                synchronized (object) {
                    block25: {
                        if (this.client_sock != null) break block25;
                        return;
                    }
                    this.in = this.client_sock.getInputStream();
                }
                int b = 0;
                while ((b = this.in.read()) != -1 && b != 9) {
                }
            }
            catch (IOException ex) {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                List list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
            finally {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                List list = this.clients;
                synchronized (list) {
                    this.clients.remove(this);
                }
            }
        }
    }

    private class ServerSocketHandler
    implements Runnable {
        Thread acceptor = null;
        final List clients = new ArrayList();

        String getName() {
            return this.acceptor != null ? this.acceptor.getName() : null;
        }

        void setName(String thread_name) {
            if (this.acceptor != null) {
                this.acceptor.setName(thread_name);
            }
        }

        ServerSocketHandler() {
            this.start();
        }

        final void start() {
            if (this.acceptor == null) {
                this.acceptor = new Thread(Util.getGlobalThreadGroup(), this, "ServerSocket acceptor thread");
                this.acceptor.setDaemon(true);
                this.acceptor.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void stop() {
            if (this.acceptor != null && this.acceptor.isAlive()) {
                try {
                    FD_SOCK.this.srv_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List list = this.clients;
            synchronized (list) {
                Iterator it = this.clients.iterator();
                while (it.hasNext()) {
                    ClientConnectionHandler handler = (ClientConnectionHandler)it.next();
                    handler.stopThread();
                }
                this.clients.clear();
            }
            this.acceptor = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.acceptor != null && FD_SOCK.this.srv_sock != null) {
                try {
                    if (FD_SOCK.this.log.isTraceEnabled()) {
                        FD_SOCK.this.log.trace((Object)("waiting for client connections on " + FD_SOCK.this.srv_sock.getInetAddress() + ":" + FD_SOCK.this.srv_sock.getLocalPort()));
                    }
                    Socket client_sock = FD_SOCK.this.srv_sock.accept();
                    if (FD_SOCK.this.log.isTraceEnabled()) {
                        FD_SOCK.this.log.trace((Object)("accepted connection from " + client_sock.getInetAddress() + ':' + client_sock.getPort()));
                    }
                    ClientConnectionHandler client_conn_handler = new ClientConnectionHandler(client_sock, this.clients);
                    List list = this.clients;
                    synchronized (list) {
                        this.clients.add(client_conn_handler);
                    }
                    client_conn_handler.start();
                }
                catch (IOException io_ex2) {
                    // empty catch block
                    break;
                }
            }
            this.acceptor = null;
        }
    }

    public static class FdHeader
    extends Header
    implements Streamable {
        public static final byte SUSPECT = 10;
        public static final byte WHO_HAS_SOCK = 11;
        public static final byte I_HAVE_SOCK = 12;
        public static final byte GET_CACHE = 13;
        public static final byte GET_CACHE_RSP = 14;
        byte type = (byte)10;
        Address mbr = null;
        IpAddress sock_addr;
        Hashtable cachedAddrs = null;
        Vector mbrs = null;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        public FdHeader(byte type, Vector mbrs) {
            this.type = type;
            this.mbrs = mbrs;
        }

        public FdHeader(byte type, Hashtable cachedAddrs) {
            this.type = type;
            this.cachedAddrs = cachedAddrs;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=").append(this.mbr);
            }
            if (this.sock_addr != null) {
                sb.append(", sock_addr=").append(this.sock_addr);
            }
            if (this.cachedAddrs != null) {
                sb.append(", cache=").append(this.cachedAddrs);
            }
            if (this.mbrs != null) {
                sb.append(", mbrs=").append(this.mbrs);
            }
            return sb.toString();
        }

        public static String type2String(byte type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_SOCK";
                }
                case 12: {
                    return "I_HAVE_SOCK";
                }
                case 13: {
                    return "GET_CACHE";
                }
                case 14: {
                    return "GET_CACHE_RSP";
                }
            }
            return "unknown type (" + type + ')';
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.mbr);
            out.writeObject(this.sock_addr);
            out.writeObject(this.cachedAddrs);
            out.writeObject(this.mbrs);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.mbr = (Address)in.readObject();
            this.sock_addr = (IpAddress)in.readObject();
            this.cachedAddrs = (Hashtable)in.readObject();
            this.mbrs = (Vector)in.readObject();
        }

        public long size() {
            long retval = 1L;
            retval += (long)Util.size(this.mbr);
            retval += (long)Util.size(this.sock_addr);
            retval += 4L;
            if (this.cachedAddrs != null) {
                Iterator it = this.cachedAddrs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Address key = (Address)entry.getKey();
                    if (key != null) {
                        retval += (long)Util.size(key);
                    }
                    ++retval;
                    IpAddress val = (IpAddress)entry.getValue();
                    if (val == null) continue;
                    retval += (long)val.size();
                }
            }
            retval += 4L;
            if (this.mbrs != null) {
                for (int i = 0; i < this.mbrs.size(); ++i) {
                    retval += (long)Util.size((Address)this.mbrs.elementAt(i));
                }
            }
            return retval;
        }

        public void writeTo(DataOutputStream out) throws IOException {
            Iterator it;
            out.writeByte(this.type);
            Util.writeAddress(this.mbr, out);
            Util.writeStreamable(this.sock_addr, out);
            int size = this.cachedAddrs != null ? this.cachedAddrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                it = this.cachedAddrs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Address key = (Address)entry.getKey();
                    IpAddress val = (IpAddress)entry.getValue();
                    Util.writeAddress(key, out);
                    Util.writeStreamable(val, out);
                }
            }
            size = this.mbrs != null ? this.mbrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                it = this.mbrs.iterator();
                while (it.hasNext()) {
                    Address address = (Address)((Object)it.next());
                    Util.writeAddress(address, out);
                }
            }
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int i;
            this.type = in.readByte();
            this.mbr = Util.readAddress(in);
            this.sock_addr = (IpAddress)Util.readStreamable(class$org$jgroups$stack$IpAddress == null ? (class$org$jgroups$stack$IpAddress = FD_SOCK.class$("org.jgroups.stack.IpAddress")) : class$org$jgroups$stack$IpAddress, in);
            int size = in.readInt();
            if (size > 0) {
                if (this.cachedAddrs == null) {
                    this.cachedAddrs = new Hashtable();
                }
                for (i = 0; i < size; ++i) {
                    Address key = Util.readAddress(in);
                    IpAddress val = (IpAddress)Util.readStreamable(class$org$jgroups$stack$IpAddress == null ? FD_SOCK.class$("org.jgroups.stack.IpAddress") : class$org$jgroups$stack$IpAddress, in);
                    this.cachedAddrs.put(key, val);
                }
            }
            if ((size = in.readInt()) > 0) {
                if (this.mbrs == null) {
                    this.mbrs = new Vector();
                }
                for (i = 0; i < size; ++i) {
                    Address addr = Util.readAddress(in);
                    this.mbrs.add(addr);
                }
            }
        }
    }
}

