/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.holders.SynchronizedIntHolder;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolEventSupport;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolListener;
import com.mchange.v2.resourcepool.ResourcePoolUtils;
import com.mchange.v2.resourcepool.TimeoutException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

class BasicResourcePool
implements ResourcePool {
    static final int CULL_FREQUENCY_DIVISOR = 4;
    HashMap managed = new HashMap();
    LinkedList unused = new LinkedList();
    HashSet excluded = new HashSet();
    ResourcePool.Manager mgr;
    BasicResourcePoolFactory factory;
    AsynchronousRunner taskRunner;
    RunnableQueue asyncEventQueue;
    Timer cullTimer;
    ResourcePoolEventSupport rpes = new ResourcePoolEventSupport(this);
    boolean broken = false;
    Object exampleResource;
    int start;
    int min;
    int max;
    int inc;
    int num_acq_attempts;
    int acq_attempt_delay;
    long max_resource_age;
    boolean age_is_absolute;
    SynchronizedIntHolder pendingAcquiresCounter = new SynchronizedIntHolder();

    public BasicResourcePool(ResourcePool.Manager manager, int n, int n2, int n3, int n4, int n5, int n6, long l, boolean bl, AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer, BasicResourcePoolFactory basicResourcePoolFactory) throws ResourcePoolException {
        try {
            this.mgr = manager;
            this.start = n;
            this.min = n2;
            this.max = n3;
            this.inc = n4;
            this.num_acq_attempts = n5;
            this.acq_attempt_delay = n6;
            this.max_resource_age = l;
            this.age_is_absolute = bl;
            this.factory = basicResourcePoolFactory;
            this.taskRunner = asynchronousRunner;
            this.asyncEventQueue = runnableQueue;
            this.cullTimer = timer;
            this.pendingAcquiresCounter.setValue(0);
            this.ensureStartResources();
            if (l > 0L) {
                long l2 = l / 4L;
                timer.schedule((TimerTask)new CullTask(), l, l2);
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            throw ResourcePoolUtils.convertThrowable(exception);
        }
    }

    public Object checkoutResource() throws ResourcePoolException, InterruptedException {
        try {
            return this.checkoutResource(0L);
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
            throw new ResourcePoolException("Huh??? TimeoutException with no timeout set!!!");
        }
    }

    public synchronized Object checkoutResource(long l) throws TimeoutException, ResourcePoolException, InterruptedException {
        this.ensureNotBroken();
        int n = this.unused.size();
        if (n == 0) {
            int n2 = this.managed.size();
            if (n2 < this.max) {
                this.postAcquireMore();
            }
            this.awaitAvailable(l);
        }
        Object e = this.unused.get(0);
        this.unused.remove(0);
        if (this.isExpired(e) || !this.attemptRefurbishResource(e)) {
            this.removeResource(e);
            this.ensureMinResources();
            return this.checkoutResource(l);
        }
        this.asyncFireResourceCheckedOut(e, this.managed.size(), this.unused.size(), this.excluded.size());
        return e;
    }

    public synchronized void checkinResource(Object object) throws ResourcePoolException {
        if (this.managed.keySet().contains(object)) {
            this.doCheckinManaged(object);
        } else if (this.excluded.contains(object)) {
            this.doCheckinExcluded(object);
        } else {
            throw new ResourcePoolException("ResourcePool: Tried to check-in a foreign resource!");
        }
    }

    public synchronized void checkinAll() throws ResourcePoolException {
        HashSet hashSet = new HashSet(this.managed.keySet());
        hashSet.removeAll(this.unused);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.doCheckinManaged(iterator.next());
        }
        Iterator iterator2 = this.excluded.iterator();
        while (iterator2.hasNext()) {
            this.doCheckinExcluded(iterator2.next());
        }
    }

    public synchronized int statusInPool(Object object) throws ResourcePoolException {
        if (this.unused.contains(object)) {
            return 0;
        }
        if (this.managed.keySet().contains(object) || this.excluded.contains(object)) {
            return 1;
        }
        return -1;
    }

    public synchronized void markBroken(Object object) {
        if (this.unused.contains(object)) {
            this.removeResource(object);
        } else {
            this.excludeResource(object);
        }
    }

    public int getMinPoolSize() {
        return this.min;
    }

    public int getMaxPoolSize() {
        return this.max;
    }

    public synchronized int getPoolSize() throws ResourcePoolException {
        return this.managed.size();
    }

    public synchronized void setPoolSize(int n) throws ResourcePoolException {
        Exception exception = this.doSetPoolSize(n);
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw ResourcePoolUtils.convertThrowable(exception);
        }
    }

    public synchronized void resetPool() {
        Iterator iterator = this.cloneOfManaged().keySet().iterator();
        while (iterator.hasNext()) {
            this.markBroken(iterator.next());
        }
        this.ensureMinResources();
    }

    public synchronized void close() throws ResourcePoolException {
        this.broken = true;
        Iterator iterator = this.cloneOfManaged().keySet().iterator();
        while (iterator.hasNext()) {
            this.removeResource(iterator.next());
        }
        if (this.factory != null) {
            this.factory.markBroken(this);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void addResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        this.rpes.addResourcePoolListener(resourcePoolListener);
    }

    public void removeResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        this.rpes.removeResourcePoolListener(resourcePoolListener);
    }

    private synchronized void unexpectedBreak() {
        this.broken = true;
        Iterator iterator = this.cloneOfUnused().iterator();
        while (iterator.hasNext()) {
            try {
                this.removeResource(iterator.next());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.factory != null) {
            this.factory.markBroken(this);
        }
    }

    private void postAcquireUntil(int n) {
        this.taskRunner.postRunnable(new AcquireTask(n));
    }

    private void postRemoveTowards(int n) {
        System.err.println("postRemoveTowards(" + n + ")");
        this.taskRunner.postRunnable(new RemoveTask(n));
    }

    private void asyncFireResourceAcquired(final Object object, final int n, final int n2, final int n3) {
        Runnable runnable = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceAcquired(object, n, n2, n3);
            }
        };
        this.asyncEventQueue.postRunnable(runnable);
    }

    private void asyncFireResourceCheckedIn(final Object object, final int n, final int n2, final int n3) {
        Runnable runnable = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceCheckedIn(object, n, n2, n3);
            }
        };
        this.asyncEventQueue.postRunnable(runnable);
    }

    private void asyncFireResourceCheckedOut(final Object object, final int n, final int n2, final int n3) {
        Runnable runnable = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceCheckedOut(object, n, n2, n3);
            }
        };
        this.asyncEventQueue.postRunnable(runnable);
    }

    private void asyncFireResourceRemoved(final Object object, final boolean bl, final int n, final int n2, final int n3) {
        Runnable runnable = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceRemoved(object, bl, n, n2, n3);
            }
        };
        this.asyncEventQueue.postRunnable(runnable);
    }

    private void destroyResource(final Object object) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    BasicResourcePool.this.mgr.destroyResource(object);
                }
                catch (Exception exception) {
                    System.err.println("Failed to destroy resource: " + object);
                    exception.printStackTrace();
                }
            }
        };
        this.taskRunner.postRunnable(runnable);
    }

    private void acquireUntil(int n) throws Exception {
        int n2;
        do {
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                n2 = this.managed.size();
                if (n2 < n) {
                    this.assimilateResource();
                }
            }
            Thread.currentThread();
            Thread.yield();
        } while (n2 < n);
    }

    private void doCheckinManaged(Object object) {
        if (!this.unused.add(object)) {
            System.err.println("Tried to check-in already checked-in resource: " + object);
            return;
        }
        if (!this.age_is_absolute) {
            this.managed.put(object, new Date());
        }
        this.asyncFireResourceCheckedIn(object, this.managed.size(), this.unused.size(), this.excluded.size());
        this.notifyAll();
    }

    private void doCheckinExcluded(Object object) {
        this.excluded.remove(object);
        this.destroyResource(object);
    }

    private Exception doSetPoolSize(int n) {
        try {
            try {
                if (n > this.max) {
                    throw new IllegalArgumentException("Requested size [" + n + "] is greater than max [" + this.max + "].");
                }
                if (n < this.min) {
                    throw new IllegalArgumentException("Requested size [" + n + "] is less than min [" + this.min + "].");
                }
                int n2 = this.managed.size();
                if (n > n2) {
                    this.acquireUntil(n);
                } else if (n < n2) {
                    int n3 = n2 - n;
                    int n4 = this.unused.size();
                    int n5 = Math.min(n3, n4);
                    int n6 = 0;
                    while (n6 < n5) {
                        this.removeResource(this.unused.get(0));
                        ++n6;
                    }
                    int n7 = n3 - n5;
                    Iterator iterator = this.cloneOfManaged().keySet().iterator();
                    int n8 = 0;
                    while (n8 < n7) {
                        this.excludeResource(iterator.next());
                        ++n8;
                    }
                }
                Exception exception = null;
                Object var11_13 = null;
                this.notifyAll();
                return exception;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                Object var11_14 = null;
                this.notifyAll();
                return exception2;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.notifyAll();
            throw throwable;
        }
    }

    private void postAcquireMore() {
        int n = this.managed.size();
        int n2 = this.pendingAcquiresCounter.getValue();
        int n3 = n + Math.max(this.inc, n2 + 1);
        this.postAcquireUntil(Math.min(n3, this.max));
    }

    private void awaitAvailable(long l) throws InterruptedException, TimeoutException {
        int n;
        long l2 = l > 0L ? System.currentTimeMillis() : -1L;
        while ((n = this.unused.size()) == 0) {
            if (this.pendingAcquiresCounter.getValue() == 0) {
                this.postAcquireMore();
            }
            this.wait(l);
            if (l <= 0L || System.currentTimeMillis() - l2 <= l) continue;
            throw new TimeoutException();
        }
    }

    private void assimilateResource() throws Exception {
        Object object = this.mgr.acquireResource();
        this.managed.put(object, new Date());
        this.unused.add(object);
        this.asyncFireResourceAcquired(object, this.managed.size(), this.unused.size(), this.excluded.size());
        this.notifyAll();
        if (this.exampleResource == null) {
            this.exampleResource = object;
        }
    }

    private void removeResource(Object object) {
        this.managed.remove(object);
        this.unused.remove(object);
        this.destroyResource(object);
        this.asyncFireResourceRemoved(object, false, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void excludeResource(Object object) {
        this.managed.remove(object);
        this.excluded.add(object);
        if (this.unused.contains(object)) {
            throw new InternalError("We should only \"exclude\" checked-out resources!");
        }
        this.asyncFireResourceRemoved(object, true, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void removeTowards(int n) {
        int n2 = this.managed.size() - n;
        int n3 = 0;
        Iterator iterator = this.cloneOfUnused().iterator();
        while (iterator.hasNext() && n3 < n2) {
            Object e = iterator.next();
            this.removeResource(e);
            ++n3;
        }
    }

    private void cullExpiredAndUnused() {
        Iterator iterator = this.cloneOfUnused().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.isExpired(e)) continue;
            this.removeResource(e);
        }
        this.ensureMinResources();
    }

    private boolean isExpired(Object object) {
        if (this.max_resource_age > 0L) {
            Date date = (Date)this.managed.get(object);
            long l = System.currentTimeMillis();
            return l - date.getTime() > this.max_resource_age;
        }
        return false;
    }

    private void ensureStartResources() {
        this.postAcquireUntil(Math.max(this.start, this.min));
    }

    private void ensureMinResources() {
        this.postAcquireUntil(this.min);
    }

    private boolean attemptRefurbishResource(Object object) {
        try {
            this.mgr.refurbishResource(object);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void ensureNotBroken() throws ResourcePoolException {
        if (this.broken) {
            throw new ResourcePoolException("Attempted to use a closed or broken resource pool");
        }
    }

    private void trace() {
        String string = this.exampleResource == null ? "" : " Ex: " + this.exampleResource;
        System.err.println(this + "  [managed: " + this.managed.size() + ", " + "unused: " + this.unused.size() + ", excluded: " + this.excluded.size() + ']' + string);
    }

    private final HashMap cloneOfManaged() {
        return (HashMap)this.managed.clone();
    }

    private final LinkedList cloneOfUnused() {
        return (LinkedList)this.unused.clone();
    }

    private final HashSet cloneOfExcluded() {
        return (HashSet)this.excluded.clone();
    }

    class RemoveTask
    implements Runnable {
        int num;

        public RemoveTask(int n) {
            this.num = n;
        }

        public void run() {
            BasicResourcePool basicResourcePool = BasicResourcePool.this;
            synchronized (basicResourcePool) {
                BasicResourcePool.this.removeTowards(this.num);
            }
        }
    }

    class CullTask
    extends TimerTask {
        CullTask() {
        }

        public void run() {
            BasicResourcePool basicResourcePool = BasicResourcePool.this;
            synchronized (basicResourcePool) {
                BasicResourcePool.this.cullExpiredAndUnused();
            }
        }
    }

    class AcquireTask
    implements Runnable {
        boolean success = false;
        int num;

        public AcquireTask(int n) {
            this.num = n;
            BasicResourcePool.this.pendingAcquiresCounter.increment();
        }

        public void run() {
            try {
                int n = 0;
                while (this.shouldTry(n)) {
                    try {
                        if (n > 0) {
                            Thread.sleep(BasicResourcePool.this.acq_attempt_delay);
                        }
                        BasicResourcePool.this.acquireUntil(this.num);
                        this.success = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n;
                }
                if (!this.success) {
                    BasicResourcePool.this.unexpectedBreak();
                }
                Object var4_3 = null;
                BasicResourcePool.this.pendingAcquiresCounter.decrement();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                BasicResourcePool.this.pendingAcquiresCounter.decrement();
                throw throwable;
            }
        }

        private boolean shouldTry(int n) {
            return !this.success && (BasicResourcePool.this.num_acq_attempts <= 0 || n < BasicResourcePool.this.num_acq_attempts);
        }
    }
}

