/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import com.mchange.v2.sql.SqlUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public abstract class JndiRefDataSource
implements DataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient Object jndiName;
    transient Hashtable jndiEnv;
    transient boolean caching = true;
    transient String factoryClassLocation;
    transient DataSource cachedInner;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_jndiName = "jndiName";
    static final String REFADDR_jndiEnv = "jndiEnv";
    static final String REFADDR_caching = "caching";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory;

    Object getJndiName() {
        return this.jndiName instanceof Name ? ((Name)this.jndiName).clone() : this.jndiName;
    }

    Hashtable getJndiEnv() {
        return (Hashtable)this.jndiEnv.clone();
    }

    boolean isCaching() {
        return this.caching;
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setJndiName(Object object) {
        if (!(object instanceof Name) && !(object instanceof String)) {
            throw new IllegalArgumentException("jndiName must be a String or a javax.naming.Name");
        }
        this.jndiName = object = object instanceof Name ? ((Name)object).clone() : object;
    }

    void setJndiEnv(Hashtable hashtable) {
        this.jndiEnv = hashtable = (Hashtable)hashtable.clone();
    }

    void setCaching(boolean bl) {
        this.caching = bl;
    }

    void setFactoryClassLocation(String string) {
        this.factoryClassLocation = string;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.jndiName, this.jndiEnv, this.caching, this.factoryClassLocation);
    }

    public Connection getConnection() throws SQLException {
        return this.inner().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.inner().getConnection(string, string2);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.inner().getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.inner().getLoginTimeout();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.inner().setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.inner().setLoginTimeout(n);
    }

    private DataSource dereference() throws SQLException {
        try {
            InitialContext initialContext = this.jndiEnv != null ? new InitialContext(this.jndiEnv) : new InitialContext();
            if (this.jndiName instanceof String) {
                return (DataSource)initialContext.lookup((String)this.jndiName);
            }
            if (this.jndiName instanceof Name) {
                return (DataSource)initialContext.lookup((Name)this.jndiName);
            }
            throw new SQLException("Could not find DataSource with JNDI name: " + this.jndiName);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            throw SqlUtils.toSQLException(namingException);
        }
    }

    private synchronized DataSource inner() throws SQLException {
        if (this.cachedInner != null) {
            return this.cachedInner;
        }
        DataSource dataSource = this.dereference();
        if (this.caching) {
            this.cachedInner = dataSource;
        }
        return dataSource;
    }

    private static boolean parseBoolean(String string) {
        return Boolean.valueOf(string);
    }

    private static char firstChar(String string) {
        return string.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference reference = new Reference((class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable = JndiRefDataSource.class$("com.mchange.v2.c3p0.impl.JndiRefDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory = JndiRefDataSource.class$("com.mchange.v2.c3p0.impl.JndiRefDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            reference.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            reference.add(new BinaryRefAddr(REFADDR_jndiName, SerializableUtils.toByteArray(this.jndiName)));
            reference.add(new BinaryRefAddr(REFADDR_jndiEnv, SerializableUtils.toByteArray(this.jndiEnv)));
            reference.add(new StringRefAddr(REFADDR_caching, String.valueOf(this.caching)));
            return reference;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NamingException("Nested Exception: " + exception.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Mutable
    extends JndiRefDataSource
    implements Serializable {
        public synchronized Object getJndiName() {
            return super.getJndiName();
        }

        public synchronized Hashtable getJndiEnv() {
            return super.getJndiEnv();
        }

        public synchronized boolean isCaching() {
            return super.isCaching();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setJndiName(Object object) {
            super.setJndiName(object);
        }

        public synchronized void setJndiEnv(Hashtable hashtable) {
            super.setJndiEnv(hashtable);
        }

        public synchronized void setCaching(boolean bl) {
            super.setCaching(bl);
        }

        public synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of JndiRefDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of JndiRefDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends JndiRefDataSource
    implements Serializable {
        protected synchronized Object getJndiName() {
            return super.getJndiName();
        }

        protected synchronized Hashtable getJndiEnv() {
            return super.getJndiEnv();
        }

        protected synchronized boolean isCaching() {
            return super.isCaching();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setJndiName(Object object) {
            super.setJndiName(object);
        }

        protected synchronized void setJndiEnv(Hashtable hashtable) {
            super.setJndiEnv(hashtable);
        }

        protected synchronized void setCaching(boolean bl) {
            super.setCaching(bl);
        }

        protected synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of JndiRefDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of JndiRefDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends JndiRefDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(Object object, Hashtable hashtable, boolean bl, String string) {
            Immutable immutable = new Immutable();
            immutable.jndiName = object;
            immutable.jndiEnv = hashtable;
            immutable.caching = bl;
            immutable.factoryClassLocation = string;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(immutable);
        }

        private Immutable() {
        }

        public Object getJndiName() {
            return super.getJndiName();
        }

        public Hashtable getJndiEnv() {
            return super.getJndiEnv();
        }

        public boolean isCaching() {
            return super.isCaching();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Immutable) {
                Immutable immutable = (Immutable)object;
                return ObjectUtils.eqOrBothNull(this.jndiName, immutable.jndiName) && ObjectUtils.eqOrBothNull(this.jndiEnv, immutable.jndiEnv) && this.caching == immutable.caching && ObjectUtils.eqOrBothNull(this.factoryClassLocation, immutable.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.jndiName) ^ ObjectUtils.hashOrZero(this.jndiEnv) ^ (this.caching ? 1 : 0) ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeShort(1);
            objectOutputStream.writeObject(this.jndiName);
            objectOutputStream.writeObject(this.jndiEnv);
            objectOutputStream.writeBoolean(this.caching);
            objectOutputStream.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            short s = objectInputStream.readShort();
            switch (s) {
                case 1: {
                    this.jndiName = objectInputStream.readObject();
                    this.jndiEnv = (Hashtable)objectInputStream.readObject();
                    this.caching = objectInputStream.readBoolean();
                    this.factoryClassLocation = (String)objectInputStream.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, s);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable;

        public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
            Reference reference;
            String string = (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.JndiRefDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable).getName();
            if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(string)) {
                int n = Integer.parseInt((String)reference.get(JndiRefDataSource.REFADDR_VERSION).getContent());
                if (n == 1) {
                    Object object2 = SerializableUtils.fromByteArray((byte[])reference.get(JndiRefDataSource.REFADDR_jndiName).getContent());
                    Hashtable hashtable2 = (Hashtable)SerializableUtils.fromByteArray((byte[])reference.get(JndiRefDataSource.REFADDR_jndiEnv).getContent());
                    boolean bl = JndiRefDataSource.parseBoolean((String)reference.get(JndiRefDataSource.REFADDR_caching).getContent());
                    return Immutable.find(object2, hashtable2, bl, reference.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + n + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

