/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public abstract class DriverManagerDataSource
implements DataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient String driverClass;
    transient String jdbcUrl;
    transient Properties properties = new Properties();
    transient String description;
    transient String factoryClassLocation;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_driverClass = "driverClass";
    static final String REFADDR_jdbcUrl = "jdbcUrl";
    static final String REFADDR_properties = "properties";
    static final String REFADDR_description = "description";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory;

    String getDriverClass() {
        return this.driverClass;
    }

    String getJdbcUrl() {
        return this.jdbcUrl;
    }

    Properties getProperties() {
        return (Properties)((Hashtable)this.properties).clone();
    }

    String getDescription() {
        return this.description;
    }

    String getUser() {
        return this.properties.getProperty("user");
    }

    String getPassword() {
        return this.properties.getProperty("password");
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setDriverClass(String string) {
        this.driverClass = string;
        this._realizeDriverClass();
    }

    void setJdbcUrl(String string) {
        this.jdbcUrl = string;
    }

    void setProperties(Properties properties) {
        this.properties = properties = (Properties)((Hashtable)properties).clone();
    }

    void setDescription(String string) {
        this.description = string;
    }

    void setUser(String string) {
        this._setUser(string);
    }

    void setPassword(String string) {
        this._setPassword(string);
    }

    void setFactoryClassLocation(String string) {
        this.factoryClassLocation = string;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.driverClass, this.jdbcUrl, this.properties, this.description, this.factoryClassLocation);
    }

    public final Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.properties);
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.overrideProps(string, string2));
    }

    public final PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public final void setLogWriter(PrintWriter printWriter) throws SQLException {
        DriverManager.setLogWriter(printWriter);
    }

    public final int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public final void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    private void _setUser(String string) {
        if (string != null) {
            ((Hashtable)this.properties).put("user", string);
        } else {
            ((Hashtable)this.properties).remove("user");
        }
    }

    private void _setPassword(String string) {
        if (string != null) {
            ((Hashtable)this.properties).put("password", string);
        } else {
            ((Hashtable)this.properties).remove("password");
        }
    }

    private final Properties overrideProps(String string, String string2) {
        Properties properties = (Properties)((Hashtable)this.properties).clone();
        ((Hashtable)properties).put("user", string);
        ((Hashtable)properties).put("password", string2);
        return properties;
    }

    void _realizeDriverClass() {
        try {
            if (this.driverClass != null) {
                Class.forName(this.driverClass);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean parseBoolean(String string) {
        return Boolean.valueOf(string);
    }

    private static char firstChar(String string) {
        return string.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference reference = new Reference((class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable = DriverManagerDataSource.class$("com.mchange.v2.c3p0.impl.DriverManagerDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory = DriverManagerDataSource.class$("com.mchange.v2.c3p0.impl.DriverManagerDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            reference.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            reference.add(new StringRefAddr(REFADDR_driverClass, this.driverClass));
            reference.add(new StringRefAddr(REFADDR_jdbcUrl, this.jdbcUrl));
            reference.add(new BinaryRefAddr(REFADDR_properties, SerializableUtils.toByteArray(this.properties)));
            reference.add(new StringRefAddr(REFADDR_description, this.description));
            return reference;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NamingException("Nested Exception: " + exception.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Mutable
    extends DriverManagerDataSource
    implements Serializable {
        public synchronized String getDriverClass() {
            return super.getDriverClass();
        }

        public synchronized String getJdbcUrl() {
            return super.getJdbcUrl();
        }

        public synchronized Properties getProperties() {
            return super.getProperties();
        }

        public synchronized String getDescription() {
            return super.getDescription();
        }

        public synchronized String getUser() {
            return super.getUser();
        }

        public synchronized String getPassword() {
            return super.getPassword();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setDriverClass(String string) {
            super.setDriverClass(string);
        }

        public synchronized void setJdbcUrl(String string) {
            super.setJdbcUrl(string);
        }

        public synchronized void setProperties(Properties properties) {
            super.setProperties(properties);
        }

        public synchronized void setDescription(String string) {
            super.setDescription(string);
        }

        public synchronized void setUser(String string) {
            super.setUser(string);
        }

        public synchronized void setPassword(String string) {
            super.setPassword(string);
        }

        public synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of DriverManagerDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of DriverManagerDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends DriverManagerDataSource
    implements Serializable {
        protected synchronized String getDriverClass() {
            return super.getDriverClass();
        }

        protected synchronized String getJdbcUrl() {
            return super.getJdbcUrl();
        }

        protected synchronized Properties getProperties() {
            return super.getProperties();
        }

        protected synchronized String getDescription() {
            return super.getDescription();
        }

        protected synchronized String getUser() {
            return super.getUser();
        }

        protected synchronized String getPassword() {
            return super.getPassword();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setDriverClass(String string) {
            super.setDriverClass(string);
        }

        protected synchronized void setJdbcUrl(String string) {
            super.setJdbcUrl(string);
        }

        protected synchronized void setProperties(Properties properties) {
            super.setProperties(properties);
        }

        protected synchronized void setDescription(String string) {
            super.setDescription(string);
        }

        protected synchronized void setUser(String string) {
            super.setUser(string);
        }

        protected synchronized void setPassword(String string) {
            super.setPassword(string);
        }

        protected synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of DriverManagerDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of DriverManagerDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends DriverManagerDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(String string, String string2, Properties properties, String string3, String string4) {
            Immutable immutable = new Immutable();
            immutable.driverClass = string;
            immutable._realizeDriverClass();
            immutable.jdbcUrl = string2;
            immutable.properties = properties;
            immutable.description = string3;
            immutable.factoryClassLocation = string4;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(immutable);
        }

        private Immutable() {
        }

        public String getDriverClass() {
            return super.getDriverClass();
        }

        public String getJdbcUrl() {
            return super.getJdbcUrl();
        }

        public Properties getProperties() {
            return super.getProperties();
        }

        public String getDescription() {
            return super.getDescription();
        }

        public String getUser() {
            return super.getUser();
        }

        public String getPassword() {
            return super.getPassword();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Immutable) {
                Immutable immutable = (Immutable)object;
                return ObjectUtils.eqOrBothNull(this.driverClass, immutable.driverClass) && ObjectUtils.eqOrBothNull(this.jdbcUrl, immutable.jdbcUrl) && ObjectUtils.eqOrBothNull(this.properties, immutable.properties) && ObjectUtils.eqOrBothNull(this.description, immutable.description) && ObjectUtils.eqOrBothNull(this.factoryClassLocation, immutable.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.driverClass) ^ ObjectUtils.hashOrZero(this.jdbcUrl) ^ ObjectUtils.hashOrZero(this.properties) ^ ObjectUtils.hashOrZero(this.description) ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeShort(1);
            objectOutputStream.writeObject(this.driverClass);
            objectOutputStream.writeObject(this.jdbcUrl);
            objectOutputStream.writeObject(this.properties);
            objectOutputStream.writeObject(this.description);
            objectOutputStream.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            short s = objectInputStream.readShort();
            switch (s) {
                case 1: {
                    this.driverClass = (String)objectInputStream.readObject();
                    this._realizeDriverClass();
                    this.jdbcUrl = (String)objectInputStream.readObject();
                    this.properties = (Properties)objectInputStream.readObject();
                    this.description = (String)objectInputStream.readObject();
                    this.factoryClassLocation = (String)objectInputStream.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, s);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable;

        public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
            Reference reference;
            String string = (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.DriverManagerDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$DriverManagerDataSource$Immutable).getName();
            if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(string)) {
                int n = Integer.parseInt((String)reference.get(DriverManagerDataSource.REFADDR_VERSION).getContent());
                if (n == 1) {
                    String string2 = (String)reference.get(DriverManagerDataSource.REFADDR_driverClass).getContent();
                    String string3 = (String)reference.get(DriverManagerDataSource.REFADDR_jdbcUrl).getContent();
                    Properties properties = (Properties)SerializableUtils.fromByteArray((byte[])reference.get(DriverManagerDataSource.REFADDR_properties).getContent());
                    String string4 = (String)reference.get(DriverManagerDataSource.REFADDR_description).getContent();
                    return Immutable.find(string2, string3, properties, string4, reference.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + n + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

