/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.async.RoundRobinAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import javax.sql.ConnectionPoolDataSource;

public final class C3P0PooledConnectionPoolManager {
    static final int DFLT_NUM_TASK_THREADS_PER_DATA_SOURCE = 3;
    Map authsToPools = new HashMap();
    final ConnectionPoolDataSource cpds;
    final RoundRobinAsynchronousRunner taskRunner;
    final Timer timer;
    final ResourcePoolFactory rpfact;
    GooGooStatementCache scache;
    int num_task_threads = 3;
    int maxStatements = C3P0Defaults.maxStatements();
    int minPoolSize = C3P0Defaults.minPoolSize();
    int maxPoolSize = C3P0Defaults.maxPoolSize();
    int maxIdleTime = C3P0Defaults.maxIdleTime();
    int acquireIncrement = C3P0Defaults.acquireIncrement();
    boolean testConnectionOnCheckout = C3P0Defaults.testConnectionOnCheckout();
    DbAuth defaultAuth = C3P0ImplUtils.NULL_AUTH;
    ConnectionTester connectionTester = C3P0Defaults.connectionTester();
    static /* synthetic */ Class class$java$lang$String;

    public C3P0PooledConnectionPoolManager(ConnectionPoolDataSource connectionPoolDataSource, DbAuth dbAuth, int n, int n2, int n3, int n4, int n5, boolean bl, ConnectionTester connectionTester) {
        this.taskRunner = new RoundRobinAsynchronousRunner(this.num_task_threads);
        this.timer = new Timer(true);
        this.rpfact = ResourcePoolFactory.createInstance(this.taskRunner, this.timer);
        this.cpds = connectionPoolDataSource;
        this.defaultAuth = dbAuth == null ? C3P0ImplUtils.NULL_AUTH : dbAuth;
        this.maxStatements = n;
        this.minPoolSize = n2;
        this.maxPoolSize = n3;
        this.maxIdleTime = n4;
        this.acquireIncrement = n5;
        this.testConnectionOnCheckout = bl;
        this.connectionTester = connectionTester;
        this.initStatementCache();
    }

    public C3P0PooledConnectionPoolManager(ConnectionPoolDataSource connectionPoolDataSource, int n) throws SQLException {
        this.taskRunner = new RoundRobinAsynchronousRunner(this.num_task_threads);
        this.timer = new Timer(true);
        this.rpfact = ResourcePoolFactory.createInstance(this.taskRunner, this.timer);
        try {
            this.cpds = connectionPoolDataSource;
            this.num_task_threads = n;
            this.defaultAuth = C3P0ImplUtils.findAuth(connectionPoolDataSource);
            BeanInfo beanInfo = Introspector.getBeanInfo(connectionPoolDataSource.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n2 = 0;
            int n3 = propertyDescriptorArray.length;
            while (n2 < n3) {
                int n4;
                Object object;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                Class<?> clazz = propertyDescriptor.getPropertyType();
                String string = propertyDescriptor.getName();
                Method method = propertyDescriptor.getReadMethod();
                if (clazz == Integer.TYPE) {
                    object = method.invoke((Object)connectionPoolDataSource, C3P0ImplUtils.NOARGS);
                    n4 = (Integer)object;
                    if ("maxStatements".equals(string)) {
                        this.maxStatements = n4;
                    } else if ("minPoolSize".equals(string)) {
                        this.minPoolSize = n4;
                    } else if ("maxPoolSize".equals(string)) {
                        this.maxPoolSize = n4;
                    } else if ("maxIdleTime".equals(string)) {
                        this.maxIdleTime = n4;
                    } else if ("acquireIncrement".equals(string)) {
                        this.acquireIncrement = n4;
                    }
                } else if (clazz == (class$java$lang$String == null ? C3P0PooledConnectionPoolManager.class$("java.lang.String") : class$java$lang$String)) {
                    object = method.invoke((Object)connectionPoolDataSource, C3P0ImplUtils.NOARGS);
                    String string2 = (String)object;
                    if ("connectionTesterClassName".equals(string)) {
                        this.connectionTester = (ConnectionTester)Class.forName(string2).newInstance();
                    }
                } else if (clazz == Boolean.TYPE) {
                    object = method.invoke((Object)connectionPoolDataSource, C3P0ImplUtils.NOARGS);
                    n4 = ((Boolean)object).booleanValue() ? 1 : 0;
                    if ("testConnectionOnCheckout".equals(string)) {
                        this.testConnectionOnCheckout = n4;
                    }
                }
                ++n2;
            }
            this.initStatementCache();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw SqlUtils.toSQLException(exception);
        }
    }

    private void initStatementCache() {
        if (this.maxStatements > 0) {
            this.scache = new GooGooStatementCache(this.taskRunner, this.maxStatements);
        }
    }

    public synchronized C3P0PooledConnectionPool getPool(DbAuth dbAuth) throws SQLException {
        C3P0PooledConnectionPool c3P0PooledConnectionPool = (C3P0PooledConnectionPool)this.authsToPools.get(dbAuth);
        if (c3P0PooledConnectionPool == null) {
            c3P0PooledConnectionPool = this.createPooledConnectionPool(dbAuth);
            this.authsToPools.put(dbAuth, c3P0PooledConnectionPool);
        }
        return c3P0PooledConnectionPool;
    }

    public C3P0PooledConnectionPool getPool() throws SQLException {
        return this.getPool(this.defaultAuth);
    }

    public synchronized void close() {
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((C3P0PooledConnectionPool)iterator.next()).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.taskRunner.close(true);
        this.timer.cancel();
        this.authsToPools = null;
    }

    protected synchronized void finalize() {
        if (this.authsToPools != null) {
            this.close();
        }
    }

    private C3P0PooledConnectionPool createPooledConnectionPool(DbAuth dbAuth) throws SQLException {
        return new C3P0PooledConnectionPool(this.cpds, dbAuth, this.minPoolSize, this.maxPoolSize, this.acquireIncrement, this.maxIdleTime, this.testConnectionOnCheckout, this.scache, this.connectionTester, this.rpfact);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

