<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:cc="http://www.redhat.com/CcTsfiMap"
  exclude-result-prefixes="cc">

  <xsl:output method="text"/>
  <xsl:param name="testSuite" select="'EAP'"/>
  
  
  <xsl:template match="/">
    <xsl:for-each select="cc:testCaseMapping">
    <xsl:for-each select="testSuite">
      <xsl:if test="@name = $testSuite">
        <xsl:for-each select="testCase">
          <xsl:if test="@name != ''">
          <xsl:variable name="pattern">
            <xsl:call-template name="replace-substring">
              <xsl:with-param name="value" select="@name" />
              <xsl:with-param name="from" select="'org.jboss'" />
              <xsl:with-param name="to" select="''" />
            </xsl:call-template>
          </xsl:variable>
            <xsl:value-of select="concat('**',translate($pattern,'.','/'),'.class')"/>
            <xsl:text>
</xsl:text>              
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
  
  
  <xsl:template name="replace-substring">
    <xsl:param name="value" />
    <xsl:param name="from" />
    <xsl:param name="to" />
    <xsl:choose>
      <xsl:when test="contains($value,$from)">
        <xsl:value-of select="substring-before($value,$from)" />
        <xsl:value-of select="$to" />
        <xsl:call-template name="replace-substring">
          <xsl:with-param name="value"
            select="substring-after($value,$from)" />
          <xsl:with-param name="from" select="$from" />
          <xsl:with-param name="to" select="$to" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$value" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>

