/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.schema.unit;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * 
 * @version <tt>$Revision: 89035 $</tt>
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 */
public class SchemaTestCase extends TestCase
{
   private static final Logger log = Logger.getLogger(SchemaTestCase.class);

   private String schemaFilename;
   
   private DocumentBuilder builder;
   
   public SchemaTestCase(String name, String schemaFilename, DocumentBuilder builder)
   {
      super(name + "-" + schemaFilename);
      this.schemaFilename = schemaFilename;
      this.builder = builder;
   }
   
   private void validateFile(String filename, DocumentBuilder builder) throws Exception
   {
      File xmlFile = new File(filename);
      log.debug("Parsing and validating " + filename);
      Document dom = builder.parse(xmlFile);
      assertNotNull(dom);
      
      log.debug("Success parsing " + filename);
   }
   
   private static DocumentBuilder getDocumentBuilder() throws Exception
   {
      DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
      factory.setAttribute("http://apache.org/xml/features/validation/schema", true);
      
      factory.setValidating(true);
      factory.setNamespaceAware(true);
         
      DocumentBuilder builder = factory.newDocumentBuilder();
      builder.setErrorHandler(new ErrorHandler() {

         public void error(SAXParseException exception) throws SAXException
         {
            log.warn("error: " + exception.getMessage(), exception);
            throw exception;
         }

         public void fatalError(SAXParseException exception) throws SAXException
         {
            log.error("fatal: " + exception.getMessage(), exception);
            throw exception;
         }

         public void warning(SAXParseException exception) throws SAXException
         {
            log.info("warning: " + exception.getMessage(), exception);
         }
      });
      
      JBossEntityResolver entityResolver = new JBossEntityResolver();
      builder.setEntityResolver(entityResolver);
      
      return builder;
   }

   public static Test suite() throws Exception
   {
      DocumentBuilder builder = getDocumentBuilder();
      TestSuite suite = new TestSuite();
      
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/bank/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/bmt/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/dd/mdb/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/dd/override/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/dd/override/META-INF/ejb-jarA.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/dd/override/META-INF/ejb-jarB.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/factoryxml/session1/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/factoryxml/session2/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/interceptors/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/interceptors2/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/jca/inflow/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/jms/managed/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/microbench/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/naming/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/securitydomain/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/service/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/stateful/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/txexceptions/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("EJB", "../src/resources/test/webservices/META-INF/ejb-jar.xml", builder));

      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/bank/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/clusteredsession/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/consumer/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/dd/mdb/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/dd/web/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/dependency/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/interceptors2/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/jca/inflow/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/mail/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/microbench/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/naming/META-INF/jboss1.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/naming/META-INF/jboss1.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/reference21_30/META-INF/jboss3.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/reference21_30/META-INF/jboss-reference.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/securitydomain/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/service/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/ssladvanced/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("JBoss", "../src/resources/test/strictpool/META-INF/jboss.xml", builder));
      
      suite.addTest(new SchemaTestCase("OptionalEJB", "../src/resources/test/dd/override/META-INF/ejb-jarC.xml", builder));
      suite.addTest(new SchemaTestCase("OptionalEJB", "../src/resources/test/dd/override/META-INF/ejb-jarD.xml", builder));
      suite.addTest(new SchemaTestCase("OptionalEJB", "../src/resources/test/enventry/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("OptionalEJB", "../src/resources/test/mail/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("OptionalEJB", "../src/resources/test/reference21_30/META-INF/ejb-jar3.xml", builder));

      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/consumer_deployment_descriptor/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/dependency/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/ejb21_client_adaptors/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/jboss_deployment_descriptor/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/jboss_resource_ref/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/jca/inflow/swiftmq/resources/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/mdb_deployment_descriptor/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/service_deployment_descriptor/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/stateful_deployment_descriptor/META-INF/jboss.xml", builder));
      suite.addTest(new SchemaTestCase("Tutorial", "../docs/tutorial/stateless_deployment_descriptor/META-INF/jboss.xml", builder));

      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/ejb21_client_adaptors/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/interceptor/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/jboss_deployment_descriptor/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/jboss_resource_ref/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/jca/inflow/swiftmq/resources/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/mdb_deployment_descriptor/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/stateful_deployment_descriptor/META-INF/ejb-jar.xml", builder));
      suite.addTest(new SchemaTestCase("TutorialEJB", "../docs/tutorial/stateless_deployment_descriptor/META-INF/ejb-jar.xml", builder));

      return suite;
   }
   
   public void runTest() throws Exception
   {
      try
      {
         validateFile(schemaFilename, builder);
      }
      catch(SAXException e)
      {
         fail(e.getMessage());
      }
   }
}
 