/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp584.web;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.ejb3.test.jbpapp584.DynamicViewRemote;
import org.jboss.ejb3.test.jbpapp584.jaas.MyPrincipal;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class MyServlet extends HttpServlet
{
   private static final long serialVersionUID = 1L;
   
   private DynamicViewRemote bean;

   @Override
   protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
   {
      // create a session for recurring visits
      req.getSession();
      
      resp.setContentType("text/plain");
      ServletOutputStream out = resp.getOutputStream();
      
      // do a blatant cast and ignore the consequences
      MyPrincipal p = (MyPrincipal) req.getUserPrincipal();
      
      // only set the option if specified, else leave it as be
      String option = req.getParameter("option");
      if(option != null)
         p.setOption(option);
      
      String results[] = bean.getResults();
      for(String result : results)
      {
         out.println(result);
      }
      
      out.flush();
   }
   
   @Override
   public void init() throws ServletException
   {
      super.init();
      
      try
      {
         InitialContext ctx = new InitialContext();
         try
         {
            bean = (DynamicViewRemote) ctx.lookup("DynamicViewBean/remote");
         }
         finally
         {
            ctx.close();
         }
      }
      catch(NamingException e)
      {
         throw new ServletException(e);
      }
   }
}
