/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp584.unit;

import javax.servlet.http.HttpServletResponse;

import junit.framework.Test;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossTestCase;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class DynamicSecurityUnitTestCase extends JBossTestCase
{
   public DynamicSecurityUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * A simple sanity test.
    */
   public void test1() throws Exception
   {
      HttpClient client = new HttpClient();
      client.getState().setCredentials(AuthScope.ANY, new UsernamePasswordCredentials("Test", "jbpapp584"));
      String host = System.getProperty("jboss.bind.address", "localhost");
      GetMethod method = new GetMethod("http://" + host + ":8080/jbpapp584/MyServlet?option=A");
      int responseCode = client.executeMethod(method);
      String actual = method.getResponseBodyAsString();
      method.releaseConnection();
      
      assertEquals("Http request failed " + actual, HttpServletResponse.SC_OK, responseCode);
      
      String expected = "org.jboss.ejb3.test.jbpapp584.jaas.MyPrincipal\r\nTest\r\nUser\r\nA\r\n";
      assertEquals(expected, actual);      
   }
   
   /**
    * Make sure that we can retain the option in one session.
    */
   public void testRetainOption() throws Exception
   {
      HttpClient client = new HttpClient();
      client.getState().setCredentials(AuthScope.ANY, new UsernamePasswordCredentials("Bill", "jbpapp584"));
      String host = System.getProperty("jboss.bind.address", "localhost");
      GetMethod method = new GetMethod();
      // do work on company A
      {
         method.setURI(new HttpURL("http://" + host + ":8080/jbpapp584/MyServlet?option=CompanyA"));
         int responseCode = client.executeMethod(method);
         String actual = method.getResponseBodyAsString();
         
         assertEquals("Http request failed " + actual, HttpServletResponse.SC_OK, responseCode);
         
         String expected = "org.jboss.ejb3.test.jbpapp584.jaas.MyPrincipal\r\nBill\r\nUser\r\nCompanyA\r\n";
         assertEquals(expected, actual);
      }
      // make sure we're in a HttpSession
      Cookie cookies[] = client.getState().getCookies();
      assertEquals(1, cookies.length);
      Cookie cookie = cookies[0];
      assertEquals("JSESSIONID", cookie.getName());
      // do more work on company A
      {
         // do not specify the option, it must have been retained
         method.setURI(new HttpURL("http://" + host + ":8080/jbpapp584/MyServlet"));
         int responseCode = client.executeMethod(method);
         String actual = method.getResponseBodyAsString();
         
         assertEquals("Http request failed " + actual, HttpServletResponse.SC_OK, responseCode);
         
         String expected = "org.jboss.ejb3.test.jbpapp584.jaas.MyPrincipal\r\nBill\r\nUser\r\nCompanyA\r\n";
         assertEquals(expected, actual);
      }
      method.releaseConnection();
   }
   
   /**
    * Make sure that we can switch options in one session.
    */
   public void testSwitchOption() throws Exception
   {
      HttpClient client = new HttpClient();
      client.getState().setCredentials(AuthScope.ANY, new UsernamePasswordCredentials("Bill", "jbpapp584"));
      String host = System.getProperty("jboss.bind.address", "localhost");
      GetMethod method = new GetMethod();
      // do work on company A
      {
         method.setURI(new HttpURL("http://" + host + ":8080/jbpapp584/MyServlet?option=CompanyA"));
         int responseCode = client.executeMethod(method);
         String actual = method.getResponseBodyAsString();
         
         assertEquals("Http request failed " + actual, HttpServletResponse.SC_OK, responseCode);
         
         String expected = "org.jboss.ejb3.test.jbpapp584.jaas.MyPrincipal\r\nBill\r\nUser\r\nCompanyA\r\n";
         assertEquals(expected, actual);
      }
      // make sure we're in a HttpSession
      Cookie cookies[] = client.getState().getCookies();
      assertEquals(1, cookies.length);
      Cookie cookie = cookies[0];
      assertEquals("JSESSIONID", cookie.getName());
      // do work on company B
      {
         method.setURI(new HttpURL("http://" + host + ":8080/jbpapp584/MyServlet?option=CompanyB"));
         int responseCode = client.executeMethod(method);
         String actual = method.getResponseBodyAsString();
         
         assertEquals("Http request failed " + actual, HttpServletResponse.SC_OK, responseCode);
         
         String expected = "org.jboss.ejb3.test.jbpapp584.jaas.MyPrincipal\r\nBill\r\nUser\r\nCompanyB\r\n";
         assertEquals(expected, actual);
      }
      method.releaseConnection();
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(DynamicSecurityUnitTestCase.class, "jbpapp584-jaas.sar,jbpapp584.jar,jbpapp584.war");
   }
}
