/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1224.unit;

import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.ejb3.test.jbpapp1224.DefaultedServiceRemote;
import org.jboss.test.JBossTestCase;

/**
 * Make sure that default values specified for attributes are actually used.
 * 
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class DefaultedMBeanUnitTestCase extends JBossTestCase
{
   public DefaultedMBeanUnitTestCase(String name)
   {
      super(name);
   }

   public void testJMX() throws Exception
   {
      ObjectName on = new ObjectName("jboss.j2ee:jar=jbpapp1224.jar,name=DefaultedServiceBean,service=EJB3,type=ManagementInterface");
      String actual = (String) getServer().getAttribute(on, "ConfigParam");
      assertEquals("${jboss.server.base.dir}/test", actual);
   }
   
   public void testRemote() throws Exception
   {
      DefaultedServiceRemote bean = (DefaultedServiceRemote) getInitialContext().lookup("DefaultedServiceBean/remote");
      String actual = bean.getConfigParam();
      assertEquals("${jboss.server.base.dir}/test", actual);
   }
   
   public void testServerFound() throws Exception
   {
      serverFound();
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(DefaultedMBeanUnitTestCase.class, "jbpapp1224.jar");
   }
}
