/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelException;
import org.jgroups.conf.ClassConfigurator;

public class MagicObjectOutputStream
extends ObjectOutputStream {
    static volatile ClassConfigurator conf = null;
    static final Log log = LogFactory.getLog((Class)MagicObjectOutputStream.class);

    public MagicObjectOutputStream(OutputStream out) throws IOException {
        super(out);
        if (conf == null) {
            try {
                conf = ClassConfigurator.getInstance(false);
            }
            catch (ChannelException e) {
                log.error((Object)"ClassConfigurator could not be instantiated", (Throwable)e);
            }
        }
    }

    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        if (conf == null) {
            super.writeInt(-1);
            super.writeClassDescriptor(desc);
            return;
        }
        int magic_num = conf.getMagicNumberFromObjectStreamClass(desc);
        super.writeInt(magic_num);
        if (magic_num == -1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("could not find magic number for '" + desc.getName() + "': writing full class descriptor"));
            }
            super.writeClassDescriptor(desc);
        }
    }
}

