/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.TunnelHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Util;

public class TUNNEL
extends Protocol
implements Runnable {
    final Properties properties = null;
    String channel_name = null;
    final Vector members = new Vector();
    String router_host = null;
    int router_port = 0;
    Address local_addr = null;
    Thread receiver = null;
    RouterStub stub = new RouterStub();
    InetAddress bind_addr = null;
    private final Object stub_mutex = new Object();
    boolean loopback = true;
    private final Reconnector reconnector = new Reconnector();
    private final Object reconnector_mutex = new Object();
    byte[] additional_data = null;
    long reconnect_interval = 5000L;

    public String toString() {
        return "Protocol TUNNEL(local_addr=" + this.local_addr + ')';
    }

    public boolean isConnected() {
        return this.stub.isConnected();
    }

    public RouterStub getRouterStub() {
        return this.stub;
    }

    public String getName() {
        return "TUNNEL";
    }

    public void init() throws Exception {
        super.init();
    }

    public void start() throws Exception {
        super.start();
        this.local_addr = this.stub.getLocalAddress();
        this.passUp(new Event(8, this.local_addr));
    }

    public void stop() {
        if (this.receiver != null) {
            this.receiver = null;
        }
        this.teardownTunnel();
        this.stopReconnector();
        this.local_addr = null;
    }

    public void startUpHandler() {
    }

    public boolean setProperties(Properties props) {
        boolean ignore_systemprops;
        super.setProperties(props);
        String str = props.getProperty("router_host");
        if (str != null) {
            this.router_host = str;
            props.remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = Integer.parseInt(str);
            props.remove("router_port");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("router_host=" + this.router_host + ";router_port=" + this.router_port));
        }
        if ((this.router_host == null || this.router_port == 0) && this.log.isErrorEnabled()) {
            this.log.error((Object)"both router_host and router_port have to be set !");
            return false;
        }
        str = props.getProperty("reconnect_interval");
        if (str != null) {
            this.reconnect_interval = Long.parseLong(str);
            props.remove("reconnect_interval");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops = Util.isBindAddressPropertyIgnored(), null)) != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                this.log.error((Object)("(bind_addr): host " + str + " not known"));
                return false;
            }
            props.remove("bind_addr");
        }
        if (this.bind_addr != null) {
            this.stub.setBindAddress(this.bind_addr);
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("The following properties are not recognized: " + sb));
            }
            return false;
        }
        return true;
    }

    public void down(Event evt) {
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        TunnelHeader hdr = new TunnelHeader(this.channel_name);
        Message msg = (Message)evt.getArg();
        Address dest = msg.getDest();
        msg.putHeader(this.getName(), hdr);
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(msg + ", hdrs: " + msg.getHeaders()));
        }
        if (this.loopback && (dest == null || dest.equals(this.local_addr) || dest.isMulticastAddress())) {
            Message copy = msg.copy();
            copy.setSrc(this.local_addr);
            evt = new Event(1, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("looped back local message " + copy));
            }
            this.passUp(evt);
            if (dest != null && !dest.isMulticastAddress()) {
                return;
            }
        }
        if (!this.stub.isConnected()) {
            this.startReconnector();
        } else if (!this.stub.send(msg, this.channel_name)) {
            this.startReconnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTunnel() throws Exception {
        if (this.router_host == null || this.router_port == 0) {
            throw new Exception("router_host and/or router_port not set correctly; tunnel cannot be created");
        }
        Object object = this.stub_mutex;
        synchronized (object) {
            this.stub.connect(this.channel_name, this.router_host, this.router_port);
            if (this.additional_data != null && this.local_addr instanceof IpAddress) {
                ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
            }
        }
    }

    void teardownTunnel() {
        this.stub.disconnect();
    }

    public void run() {
        while (this.receiver != null && Thread.currentThread().equals(this.receiver)) {
            try {
                Message msg = this.stub.receive();
                if (msg == null) {
                    if (this.receiver == null) break;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"received a null message. Trying to reconnect to router");
                    }
                    if (!this.stub.isConnected()) {
                        this.startReconnector();
                    }
                    Util.sleep(5000L);
                    continue;
                }
                this.handleIncomingMessage(msg);
            }
            catch (Exception e) {
                if (this.receiver == null || !Thread.currentThread().equals(this.receiver)) {
                    return;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)"exception in receiver thread", (Throwable)e);
            }
        }
    }

    public void handleIncomingMessage(Message msg) {
        String ch_name;
        TunnelHeader hdr = (TunnelHeader)msg.removeHeader(this.getName());
        if (this.loopback) {
            Address dst = msg.getDest();
            Address src = msg.getSrc();
            if (dst != null && dst.isMulticastAddress() && src != null && this.local_addr.equals(src)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"discarded own loopback multicast packet");
                }
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(msg + ", hdrs: " + msg.getHeaders()));
        }
        String string = ch_name = hdr != null ? hdr.channel_name : null;
        if (ch_name != null && !this.channel_name.equals(ch_name)) {
            return;
        }
        this.passUp(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDownEvent(Event evt) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)evt);
        }
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!(this.local_addr instanceof IpAddress) || this.additional_data == null) break;
                ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
                break;
            }
            case 2: {
                this.channel_name = (String)evt.getArg();
                if (this.stub == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"CONNECT:  router stub is null!");
                    }
                } else {
                    try {
                        this.createTunnel();
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("failed connecting to GossipRouter at " + this.router_host + ":" + this.router_port));
                        break;
                    }
                }
                this.receiver = new Thread((Runnable)this, "TUNNEL receiver thread");
                this.receiver.setDaemon(true);
                this.receiver.start();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                if (this.receiver != null) {
                    this.receiver = null;
                    this.stub.disconnect();
                }
                this.teardownTunnel();
                this.passUp(new Event(5));
                this.passUp(new Event(8, null));
                this.local_addr = null;
                break;
            }
            case 56: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReconnector() {
        Object object = this.reconnector_mutex;
        synchronized (object) {
            this.reconnector.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnector() {
        Object object = this.reconnector_mutex;
        synchronized (object) {
            this.reconnector.stop();
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
    }

    private class Reconnector
    implements Runnable {
        Thread my_thread = null;

        private Reconnector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Reconnector reconnector = this;
            synchronized (reconnector) {
                if (this.my_thread == null || !this.my_thread.isAlive()) {
                    this.my_thread = new Thread((Runnable)this, "Reconnector");
                    this.my_thread.setDaemon(true);
                    this.my_thread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Reconnector reconnector = this;
            synchronized (reconnector) {
                this.my_thread = null;
            }
        }

        public void run() {
            while (Thread.currentThread().equals(this.my_thread)) {
                try {
                    TUNNEL.this.stub.reconnect();
                    if (!TUNNEL.this.log.isTraceEnabled()) break;
                    TUNNEL.this.log.trace((Object)"reconnected");
                    break;
                }
                catch (Exception exception) {
                    Util.sleep(TUNNEL.this.reconnect_interval);
                }
            }
        }
    }
}

