/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.protocols.Discovery;
import org.jgroups.util.Util;

public class PingSender
implements Runnable {
    Thread t = null;
    long timeout = 3000L;
    double interval;
    int num_requests = 1;
    Discovery discovery_prot;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean trace = this.log.isTraceEnabled();

    public PingSender(long timeout, int num_requests, Discovery d) {
        this.timeout = timeout;
        this.num_requests = num_requests;
        this.discovery_prot = d;
        this.interval = (double)timeout / (double)num_requests;
    }

    public synchronized void start() {
        if (this.t == null || !this.t.isAlive()) {
            this.t = new Thread((Runnable)this, "PingSender");
            this.t.setDaemon(true);
            this.t.start();
        }
    }

    public synchronized void stop() {
        if (this.t != null) {
            Thread tmp = this.t;
            this.t = null;
            try {
                tmp.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.t != null && this.t.isAlive();
    }

    public void run() {
        for (int i = 0; i < this.num_requests && this.t != null && this.t.equals(Thread.currentThread()); ++i) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"sending GET_MBRS_REQ");
            }
            this.discovery_prot.sendGetMembersRequest();
            Util.sleep((long)this.interval);
        }
    }
}

