/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class HttpClient {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.HttpClient");
    private HttpConnection connection = null;
    private HttpState state;

    public HttpState getState() {
        if (null == this.state) {
            this.state = new HttpState();
        }
        return this.state;
    }

    public void setState(HttpState state) {
        this.state = state;
    }

    public void startSession(String host, int port) {
        this.startSession(host, port, false);
    }

    public void startSession(String host, int port, boolean https) {
        if (log.isDebugEnabled()) {
            log.debug("HttpClient.startSession(String,int,boolean): Host:" + host + " Port:" + port + " HTTPS:" + https);
        }
        this.connection = new HttpConnection(host, port, https);
    }

    public void startSession(String host, int port, Credentials creds) {
        this.startSession(host, port, creds, false);
    }

    public void startSession(String host, int port, Credentials creds, boolean https) {
        if (log.isDebugEnabled()) {
            log.debug("HttpClient.startSession(String,int,Credentials,boolean): Host:" + host + " Port:" + port + " Credentials:" + creds + " HTTPS:" + https);
        }
        this.getState().setCredentials(null, creds);
        this.connection = new HttpConnection(host, port, https);
    }

    public void startSession(URL url) {
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            this.startSession(url.getHost(), url.getPort() == -1 ? 443 : url.getPort(), true);
        } else if ("http".equalsIgnoreCase(url.getProtocol())) {
            this.startSession(url.getHost(), url.getPort() == -1 ? 80 : url.getPort(), false);
        } else {
            throw new IllegalArgumentException("Protocol " + url.getProtocol() + " not supported in URL " + url);
        }
    }

    public void startSession(URL url, Credentials creds) {
        this.getState().setCredentials(null, creds);
        this.startSession(url);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport) {
        this.startSession(host, port, proxyhost, proxyport, false);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport, boolean secure) {
        this.connection = new HttpConnection(proxyhost, proxyport, host, port, secure);
    }

    public synchronized int executeMethod(HttpMethod method) throws IOException, HttpException {
        if (null == method) {
            throw new NullPointerException("HttpMethod parameter");
        }
        if (null == this.connection) {
            throw new IllegalStateException("The startSession method must be called before executeMethod");
        }
        if (!this.connection.isOpen()) {
            this.connection.open();
        }
        return method.execute(this.getState(), this.connection);
    }

    public void endSession() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("HttpClient.endSession()");
        }
        if (null != this.connection) {
            this.connection.close();
            this.connection = null;
        }
    }
}

