/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.Serializable;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class Cookie
extends NameValuePair
implements Serializable,
Comparator {
    private String _comment;
    private String _domain;
    private Date _expiryDate;
    private String _path;
    private boolean _secure;
    private boolean _hasPathAttribute = false;
    private boolean _hasDomainAttribute = false;
    private int _version = 0;
    private static final DateFormat[] expiryFormats = new DateFormat[6];
    private static final RuleBasedCollator stringCollator = (RuleBasedCollator)Collator.getInstance(new Locale("en", "US", ""));
    private static final Log log;

    public Cookie(String domain, String name, String value) {
        this(domain, name, value, null, null, false);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        super(name, value);
        this.setPath(path);
        this.setDomain(domain);
        this.setExpiryDate(expires);
        this.setSecure(secure);
    }

    public Cookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this(domain, name, value, path, new Date(System.currentTimeMillis() + (long)maxAge * 1000L), secure);
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public Date getExpiryDate() {
        return this._expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this._expiryDate = expiryDate;
    }

    public boolean isPersistent() {
        return null != this._expiryDate;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setDomain(String domain) {
        if (domain != null) {
            int ndx = domain.indexOf(":");
            if (ndx != -1) {
                domain = domain.substring(0, ndx);
            }
            this._domain = domain.toLowerCase();
        }
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public boolean getSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public boolean isExpired() {
        return this._expiryDate != null && this._expiryDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isExpired(Date now) {
        return this._expiryDate != null && this._expiryDate.getTime() <= now.getTime();
    }

    public void setPathAttributeSpecified(boolean value) {
        this._hasPathAttribute = value;
    }

    public boolean isPathAttributeSpecified() {
        return this._hasPathAttribute;
    }

    public void setDomainAttributeSpecified(boolean value) {
        this._hasDomainAttribute = value;
    }

    public boolean isDomainAttributeSpecified() {
        return this._hasDomainAttribute;
    }

    public int hashCode() {
        return super.hashCode() ^ (null == this._path ? 0 : this._path.hashCode()) ^ (null == this._domain ? 0 : this._domain.hashCode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        boolean bl;
        boolean bl2;
        if (obj == null) return false;
        if (!(obj instanceof Cookie)) return false;
        Cookie that = (Cookie)obj;
        if (null == this.getName()) {
            if (null != that.getName()) return false;
            bl2 = true;
        } else {
            bl2 = this.getName().equals(that.getName());
        }
        if (!bl2) return false;
        if (null == this.getPath()) {
            if (null != that.getPath()) return false;
            bl = true;
        } else {
            bl = this.getPath().equals(that.getPath());
        }
        if (!bl) return false;
        if (null == this.getDomain()) {
            if (null != that.getDomain()) return false;
            return true;
        }
        boolean bl3 = this.getDomain().equals(that.getDomain());
        if (!bl3) return false;
        return true;
    }

    public String toExternalForm() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append("=").append(this.getValue());
        if (this._path != null && this.isPathAttributeSpecified()) {
            buf.append("; $Path=");
            buf.append(this._path);
        }
        if (this._domain != null && this.isDomainAttributeSpecified()) {
            buf.append("; $Domain=");
            buf.append(this._domain);
        }
        return buf.toString();
    }

    public boolean matches(String domain, int port, String path, boolean secure, Date now) {
        domain = domain.toLowerCase();
        return (this.getExpiryDate() == null || this.getExpiryDate().after(now)) && this.getDomain() != null && Cookie.domainMatch(domain, this.getDomain()) && this.getPath() != null && path.startsWith(this.getPath()) && (this.getSecure() ? secure : true);
    }

    public boolean matches(String domain, int port, String path, boolean secure) {
        return this.matches(domain, port, path, secure, new Date());
    }

    public static Header createCookieHeader(String domain, String path, Cookie[] cookies) {
        return Cookie.createCookieHeader(domain, path, false, cookies);
    }

    public static Header createCookieHeader(String domain, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        if (domain == null) {
            throw new IllegalArgumentException("null domain in createCookieHeader.");
        }
        int port = secure ? 443 : 80;
        int ndx = domain.indexOf(":");
        if (ndx != -1) {
            try {
                port = Integer.parseInt(domain.substring(ndx + 1, domain.length()));
            }
            catch (NumberFormatException e) {
                log.warn("Cookie.createCookieHeader():  Invalid port number in domain " + domain);
            }
        }
        return Cookie.createCookieHeader(domain, port, path, secure, cookies);
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        return Cookie.createCookieHeader(domain, port, path, secure, new Date(), cookies);
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Date now, Cookie[] cookies) throws IllegalArgumentException {
        if (domain == null) {
            throw new IllegalArgumentException("null domain in createCookieHeader.");
        }
        if (path == null) {
            throw new IllegalArgumentException("null path in createCookieHeader.");
        }
        boolean added = false;
        StringBuffer value = new StringBuffer();
        if (cookies.length <= 0) {
            return null;
        }
        LinkedList addedCookies = new LinkedList();
        int i = 0;
        while (i < cookies.length) {
            if (cookies[i].matches(domain, port, path, secure, now)) {
                Cookie.addInPathOrder(addedCookies, cookies[i]);
                added = true;
            }
            ++i;
        }
        if (added) {
            value.append("$Version=");
            value.append(((Cookie)addedCookies.get(0)).getVersion());
            Iterator itr = addedCookies.iterator();
            while (itr.hasNext()) {
                Cookie cookie = (Cookie)itr.next();
                value.append("; ");
                value.append(cookie.toExternalForm());
            }
            return new Header("Cookie", value.toString());
        }
        return null;
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof Cookie)) {
            throw new ClassCastException(o1.getClass().getName());
        }
        if (!(o2 instanceof Cookie)) {
            throw new ClassCastException(o2.getClass().getName());
        }
        Cookie c1 = (Cookie)o1;
        Cookie c2 = (Cookie)o2;
        if (c1.getPath() == null && c2.getPath() == null) {
            return 0;
        }
        if (c1.getPath() == null) {
            if (c2.getPath().equals("/")) {
                return 0;
            }
            return -1;
        }
        if (c2.getPath() == null) {
            if (c1.getPath().equals("/")) {
                return 0;
            }
            return 1;
        }
        return stringCollator.compare(c1.getPath(), c2.getPath());
    }

    public String toString() {
        return this.toExternalForm();
    }

    public static Cookie[] parse(String domain, int port, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        return Cookie.parse(domain, port, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        return Cookie.parse(domain, 80, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, String path, boolean secure, Header setCookie) throws HttpException {
        return Cookie.parse(domain, secure ? 443 : 80, path, secure, setCookie);
    }

    public static Cookie[] parse(String domain, int port, String path, boolean secure, Header setCookie) throws HttpException, IllegalArgumentException {
        if (domain == null) {
            throw new IllegalArgumentException("domain may not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("path may not be null.");
        }
        if (path.length() == 0) {
            log.debug("Cookie.parse():  Fixing up empty request path.");
            path = "/";
        }
        String defaultPath = null;
        int lastSlashIndex = path.lastIndexOf("/");
        defaultPath = lastSlashIndex == 0 ? "/" : (lastSlashIndex > 0 ? path.substring(0, lastSlashIndex) : path);
        HeaderElement[] headerElements = HeaderElement.parse(setCookie.getValue());
        Cookie[] cookies = new Cookie[headerElements.length];
        int index = 0;
        int i = 0;
        while (i < headerElements.length) {
            Cookie cookie = new Cookie(domain, headerElements[i].getName(), headerElements[i].getValue(), defaultPath, null, false);
            NameValuePair[] parameters = headerElements[i].getParameters();
            if (parameters != null) {
                boolean discard_set = false;
                boolean secure_set = false;
                int j = 0;
                while (j < parameters.length) {
                    String name = parameters[j].getName().toLowerCase();
                    if ((name.equals("version") || name.equals("max-age") || name.equals("domain") || name.equals("path") || name.equals("comment") || name.equals("expires")) && parameters[j].getValue() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Cookie.parse(): Unable to parse set-cookie header \"" + setCookie.getValue() + "\" because \"" + parameters[j].getName() + "\" requires a value in cookie \"" + headerElements[i].getName() + "\".");
                        }
                        throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nMissing value for " + parameters[j].getName() + " attribute in cookie '" + headerElements[i].getName() + "'");
                    }
                    if (name.equals("version")) {
                        try {
                            cookie.setVersion(Integer.parseInt(parameters[j].getValue()));
                        }
                        catch (NumberFormatException nfe) {
                            if (log.isDebugEnabled()) {
                                log.debug("Cookie.parse(): Exception attempting to parse set-cookie header \"" + setCookie.getValue() + "\" because version attribute value \"" + parameters[j].getValue() + "\" is not a number in cookie \"" + headerElements[i].getName() + "\".", nfe);
                            }
                            throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nVersion '" + parameters[j].getValue() + "' not a number");
                        }
                    }
                    if (name.equals("path")) {
                        cookie.setPath(parameters[j].getValue());
                        cookie.setPathAttributeSpecified(true);
                    } else if (name.equals("domain")) {
                        String d = parameters[j].getValue().toLowerCase();
                        if (d.charAt(0) != '.' && !d.equals(domain)) {
                            cookie.setDomain("." + d);
                        } else {
                            cookie.setDomain(d);
                        }
                        cookie.setDomainAttributeSpecified(true);
                    } else if (name.equals("max-age")) {
                        int age;
                        try {
                            age = Integer.parseInt(parameters[j].getValue());
                        }
                        catch (NumberFormatException e) {
                            if (log.isDebugEnabled()) {
                                log.debug("Cookie.parse(): Exception attempting to parse set-cookie header \"" + setCookie.getValue() + "\" because max-age attribute value \"" + parameters[j].getValue() + "\" is not a number in cookie \"" + headerElements[i].getName() + "\".", e);
                            }
                            throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Max-Age '" + parameters[j].getValue() + "' not a number");
                        }
                        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
                    } else if (name.equals("secure")) {
                        cookie.setSecure(true);
                    } else if (name.equals("comment")) {
                        cookie.setComment(parameters[j].getValue());
                    } else if (name.equals("expires")) {
                        boolean set = false;
                        String expiryDate = parameters[j].getValue();
                        if (null != expiryDate && expiryDate.length() > 1 && expiryDate.startsWith("'") && expiryDate.endsWith("'")) {
                            expiryDate = expiryDate.substring(1, expiryDate.length() - 1);
                        }
                        int k = 0;
                        while (k < expiryFormats.length) {
                            try {
                                Date date = expiryFormats[k].parse(expiryDate);
                                cookie.setExpiryDate(date);
                                set = true;
                                break;
                            }
                            catch (ParseException e) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Cookie.parse(): Exception attempting to parse set-cookie header \"" + setCookie.getValue() + "\" because expires attribute value \"" + parameters[j].getValue() + "\" cannot be parsed by date format \"" + k + "\" in cookie " + headerElements[i].getName() + "\". Will try another.");
                                }
                                ++k;
                            }
                        }
                        if (!set) {
                            if (log.isInfoEnabled()) {
                                log.info("Cookie.parse(): Unable to parse expiration date parameter: \"" + expiryDate + "\"");
                            }
                            throw new HttpException("Unable to parse expiration date parameter: \"" + expiryDate + "\"");
                        }
                    }
                    ++j;
                }
            }
            if (cookie.getVersion() < 0 || cookie.getVersion() > 1) {
                if (log.isInfoEnabled()) {
                    log.info("Cookie.parse(): Rejecting set cookie header \"" + setCookie.getValue() + "\" because it has an unrecognized version attribute (" + cookie.getVersion() + ").");
                }
                throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Illegal Version attribute");
            }
            if (cookie.getDomain() != null && !cookie.getDomain().equals("localhost") && domain.indexOf(".") >= 0) {
                if (!domain.endsWith(cookie.getDomain())) {
                    if (log.isInfoEnabled()) {
                        log.info("Cookie.parse(): Rejecting set cookie header \"" + setCookie.getValue() + "\" because \"" + cookie.getName() + "\" has an illegal domain attribute (\"" + cookie.getDomain() + "\") for the domain \"" + domain + "\".");
                    }
                    throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Illegal domain attribute" + cookie.getDomain());
                }
                if (cookie.getVersion() == 0) {
                    int domainParts = new StringTokenizer(cookie.getDomain(), ".").countTokens();
                    if (Cookie.isSpecialDomain(cookie.getDomain())) {
                        if (domainParts < 2) {
                            if (log.isInfoEnabled()) {
                                log.info("Cookie.parse(): Rejecting set cookie header \"" + setCookie.getValue() + "\" because \"" + cookie.getName() + "\" has an illegal domain attribute (\"" + cookie.getDomain() + "\") for the given domain \"" + domain + "\".  It violoates the Netscape cookie specification for special TLDs.");
                            }
                            throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Illegal domain attribute " + cookie.getDomain());
                        }
                    } else if (domainParts < 3) {
                        if (log.isInfoEnabled()) {
                            log.info("Cookie.parse(): Rejecting set cookie header \"" + setCookie.getValue() + "\" because \"" + cookie.getName() + "\" has an illegal domain attribute (\"" + cookie.getDomain() + "\") for the given domain \"" + domain + "\".  It violoates the Netscape cookie specification for non-special TLDs.");
                        }
                        throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Illegal domain attribute " + cookie.getDomain());
                    }
                } else {
                    int dotIndex = cookie.getDomain().indexOf(46, 1);
                    if (dotIndex < 0 || dotIndex == cookie.getDomain().length() - 1) {
                        throw new HttpException("Bad set-cookie header:  " + setCookie.getValue() + "Illegal domain attribute " + cookie.getDomain() + ".  The domain contains no embedded dots.");
                    }
                    if (domain.substring(0, domain.length() - cookie.getDomain().length()).indexOf(46) != -1) {
                        if (log.isInfoEnabled()) {
                            log.info("Cookie.parse(): Rejecting set cookie header \"" + setCookie.getValue() + "\" because \"" + cookie.getName() + "\" has an illegal domain attribute (\"" + cookie.getDomain() + "\") for the given domain \"" + domain + "\".");
                        }
                        throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Illegal domain attribute " + cookie.getDomain());
                    }
                }
            }
            if (cookie.getPath() != null && !path.startsWith(cookie.getPath())) {
                if (log.isInfoEnabled()) {
                    log.info("Cookie.parse(): Rejecting set cookie header \"" + setCookie.getValue() + "\" because \"" + cookie.getName() + "\" has an illegal path attribute (\"" + cookie.getPath() + "\") for the given path \"" + path + "\".");
                }
                throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Header targets a different path, found \"" + cookie.getPath() + "\" for \"" + path + "\"");
            }
            if (null == cookie.getPath() && null != path) {
                if (!path.endsWith("/")) {
                    int x = path.lastIndexOf("/");
                    if (0 < x) {
                        cookie.setPath(path.substring(0, x));
                    } else {
                        cookie.setPath("/");
                    }
                } else {
                    cookie.setPath(path);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Cookie.parse():  Adding cookie - " + cookie.toString());
            }
            cookies[index++] = cookie;
            ++i;
        }
        return cookies;
    }

    private static boolean isSpecialDomain(String domain) {
        String ucDomain = domain.toUpperCase();
        return ucDomain.endsWith(".COM") || ucDomain.endsWith(".EDU") || ucDomain.endsWith(".NET") || ucDomain.endsWith(".GOV") || ucDomain.endsWith(".MIL") || ucDomain.endsWith(".ORG") || ucDomain.endsWith(".INT");
    }

    private static boolean domainMatch(String host, String domain) {
        boolean match = host.equals(domain) || domain.startsWith(".") && host.endsWith(domain);
        return match;
    }

    private static void addInPathOrder(List list, Cookie addCookie) {
        int i = 0;
        i = 0;
        while (i < list.size()) {
            Cookie c = (Cookie)list.get(i);
            if (addCookie.compare(addCookie, c) > 0) break;
            ++i;
        }
        list.add(i, addCookie);
    }

    static {
        Cookie.expiryFormats[0] = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        Cookie.expiryFormats[1] = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        Cookie.expiryFormats[2] = new SimpleDateFormat("EEE dd-MMM-yy HH:mm:ss z", Locale.US);
        Cookie.expiryFormats[3] = new SimpleDateFormat("EEE dd-MMM-yyyy HH:mm:ss z", Locale.US);
        Cookie.expiryFormats[4] = new SimpleDateFormat("EEE dd MMM yy HH:mm:ss z", Locale.US);
        Cookie.expiryFormats[5] = new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z", Locale.US);
        log = LogSource.getInstance("org.apache.commons.httpclient.Cookie");
    }
}

