/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jboss.ant.tasks.build.BuildTask;
import org.jboss.ant.types.Compatible;
import org.jboss.ant.types.ComponentRef;
import org.jboss.ant.types.Import;
import org.jboss.ant.types.attributes.Version;
import org.jboss.ant.types.build.Build;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.util.DownloadUtil;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.ImportUtil;
import org.jboss.ant.util.graph.ComponentRefGraphChildResolverVistor;
import org.jboss.ant.util.graph.ComponentRefGraphFileResolverVisitor;
import org.jboss.ant.util.graph.ComponentRefVertex;
import org.jboss.ant.util.graph.Graph;
import org.jboss.ant.util.graph.RootVertex;

public class SynchronizeComponentsTask
extends BuildTask {
    private String build;

    public void execute() throws BuildException {
        Graph componentRefGraph = this.createInitialGraph();
        ComponentRefGraphFileResolverVisitor fileResolverVisitor = new ComponentRefGraphFileResolverVisitor();
        ComponentRefGraphChildResolverVistor childResolverVisitor = new ComponentRefGraphChildResolverVistor();
        this.resolveDependencies(componentRefGraph, fileResolverVisitor, childResolverVisitor);
        this.getBuildInstance().setGraph(componentRefGraph);
    }

    private void resolveDependencies(Graph componentGraph, ComponentRefGraphFileResolverVisitor fileResolver, ComponentRefGraphChildResolverVistor childResolver) throws BuildException {
        do {
            fileResolver.getUnresolvedComponents().clear();
            childResolver.getUnexpandedVertexes().clear();
            componentGraph.clearMark();
            componentGraph.breadthFirstSearch(componentGraph.getVertex(0), fileResolver);
            this.downloadDependencies(fileResolver.getUnresolvedComponents());
            componentGraph.clearMark();
            componentGraph.breadthFirstSearch(componentGraph.getVertex(0), childResolver);
            this.importComponents(childResolver.getUnexpandedVertexes(), componentGraph);
        } while (fileResolver.getUnresolvedComponents().size() != 0 || childResolver.getUnexpandedVertexes().size() != 0);
        componentGraph.clearMark();
    }

    private void importComponents(Vector unexpandedVertexes, Graph graph) throws BuildException {
        super.log("importComponents, unexpandedVertexes: " + unexpandedVertexes, 3);
        Project project = this.getProject();
        int i = 0;
        while (i < unexpandedVertexes.size()) {
            ComponentRefVertex currentComponentVertex = (ComponentRefVertex)unexpandedVertexes.elementAt(i);
            ComponentRef currentComponentRef = currentComponentVertex.getComponentRef();
            super.log("[" + i + "]: " + currentComponentRef.getName());
            Component newComponent = (Component)((Object)project.getReference(currentComponentRef.getName()));
            if (newComponent == null) {
                ImportUtil.importFile(currentComponentRef.getComponentFile(), project);
                super.log("checking componentref: " + currentComponentRef.getName(), 3);
                newComponent = (Component)((Object)project.getReference(currentComponentRef.getName()));
                super.log("imported new component: " + (Object)((Object)newComponent), 3);
                if (newComponent == null) {
                    throw new BuildException("Failed to find componentref: " + currentComponentRef.getName());
                }
            } else {
                super.log("Checking currentComponentRef: " + (Object)((Object)currentComponentRef));
                super.log("against newComponent: " + (Object)((Object)newComponent));
                super.log("Creating a new version from string: " + newComponent.getVersion().toString() + " . This version will be placed in a compatible.", 3);
                Version newVersion = newComponent.getVersion();
                Compatible newVersionInfo = new Compatible(newVersion);
                SortedSet oldVersions = currentComponentRef.getCompatibleVersions();
                if (oldVersions != null && !oldVersions.contains(newVersionInfo) && !newVersionInfo.getVersion().toString().equalsIgnoreCase("snapshot")) {
                    String newCompID = newComponent.getId();
                    String importCompID = currentComponentRef.getImportingComponent().getId();
                    if (project.getProperty("disableVersionCheck") == null) {
                        throw new BuildException("A versioning problem exists:\nComponent: " + newCompID + " is at version: " + newVersion + "\n but it is also required to be compatible with: " + oldVersions + "\n by: " + importCompID);
                    }
                }
            }
            if (!this.getBuildInstance().componentExists(newComponent)) {
                this.getBuildInstance().addComponent(newComponent);
            }
            currentComponentRef.setComponent(newComponent);
            int j = 0;
            while (j < newComponent.getImports().size()) {
                Import currentImport = (Import)((Object)newComponent.getImports().elementAt(j));
                ComponentRef newComponentRef = new ComponentRef(currentImport);
                newComponentRef.setProject(project);
                newComponentRef.setName(currentImport.getComponentRef());
                SortedSet compatibles = currentImport.getCompatibleVersions();
                newComponentRef.setCompatibleVersions(compatibles);
                this.getBuildInstance().addComponentRef(newComponentRef);
                ComponentRefVertex newComponentVertex = new ComponentRefVertex(newComponentRef.getId());
                newComponentVertex.setComponentRef(newComponentRef);
                graph.addVertex(newComponentVertex);
                graph.addEdge(currentComponentVertex, newComponentVertex, 0);
                ++j;
            }
            ++i;
        }
    }

    private void downloadDependencies(Vector unresolvedComponents) {
        int i = 0;
        while (i < unresolvedComponents.size()) {
            File downloadedFile;
            ComponentRefVertex currentComponentVertex = (ComponentRefVertex)unresolvedComponents.elementAt(i);
            ComponentRef currentComponentRef = currentComponentVertex.getComponentRef();
            File filename = FileUtil.resolve(currentComponentRef.getThirdpartyDir(), currentComponentRef.getFilename());
            File thirdpartyVersionedDir = currentComponentRef.getThirdpartyDir();
            if (!thirdpartyVersionedDir.exists()) {
                FileUtil.mkdir(thirdpartyVersionedDir, this.getProject());
                filename = FileUtil.resolve(currentComponentRef.getThirdpartyDir(), currentComponentRef.getFilename());
            }
            URL repositoryFile = null;
            try {
                repositoryFile = FileUtil.resolve(currentComponentRef.getLocation(), currentComponentRef.getFilename());
            }
            catch (MalformedURLException e) {
                throw new BuildException(String.valueOf(repositoryFile.getProtocol()) + "://" + repositoryFile.getHost() + "/" + repositoryFile.getPath() + "/" + repositoryFile.getFile(), (Throwable)e);
            }
            if (currentComponentRef.getCompatibleVersions() != null) {
                if (!currentComponentRef.getCompatibleVersions().isEmpty() && filename.exists()) {
                    super.log("We are attempting to download dependencies, for a compatible.  A component-info.xml already exists for this item We will not download this file", 4);
                    currentComponentRef.setFileResolved(true);
                } else if (!currentComponentRef.getCompatibleVersions().isEmpty() && !filename.exists()) {
                    super.log("We are attempting to download dependencies, for a compatible.  A component-info.xml does not yet exist for this item ", 4);
                    downloadedFile = DownloadUtil.getFile(filename, repositoryFile, this.getProject());
                    currentComponentRef.setFileResolved(true);
                }
            } else {
                downloadedFile = DownloadUtil.getFile(filename, repositoryFile, this.getProject());
                currentComponentRef.setFileResolved(true);
            }
            ++i;
        }
    }

    private void viewUnresolvedDependencies(ComponentRefGraphFileResolverVisitor visitor) {
        System.out.println("Currently the following components are unresolved:");
        int i = 0;
        while (i < visitor.getUnresolvedComponents().size()) {
            Component unresolvedComponent = (Component)((Object)visitor.getUnresolvedComponents().elementAt(i));
            System.out.println(unresolvedComponent.getId());
            ++i;
        }
    }

    private Graph createInitialGraph() {
        Graph componentRefGraph = new Graph();
        RootVertex root = new RootVertex("ROOT");
        componentRefGraph.addVertex(root);
        Build mainBuild = this.getBuildInstance();
        int i = 0;
        while (i < mainBuild.getComponentRefs().size()) {
            ComponentRef currentComponentRef = (ComponentRef)((Object)mainBuild.getComponentRefs().elementAt(i));
            ComponentRefVertex componentRefVertex = new ComponentRefVertex(currentComponentRef.getName());
            componentRefVertex.setComponentRef(currentComponentRef);
            componentRefGraph.addVertex(componentRefVertex);
            componentRefGraph.addEdge(root, componentRefVertex, 1);
            ++i;
        }
        return componentRefGraph;
    }

    private ComponentRefGraphFileResolverVisitor createVisitor() {
        ComponentRefGraphFileResolverVisitor visitor = new ComponentRefGraphFileResolverVisitor();
        return visitor;
    }
}

