/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Rmic;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.ant.tasks.build.BuildTask;

public class RMICHelper
extends BuildTask {
    private String base;
    private String classname;
    private String verify;
    private String debug;
    private String iiop;
    private String idl;
    private String includes;
    private String external;
    private Path classpath;
    private String stubversion;

    public void execute() {
        this.setTaskName("RMICHelper");
        if (this.getExternal() != null && this.getExternal().equalsIgnoreCase("true")) {
            String[] classes = this.getIncludes().split(", ");
            int i = 0;
            while (i < classes.length) {
                Rmic rmic = new Rmic();
                rmic.setTaskName("rmic");
                rmic.setProject(this.getProject());
                this.getProject().log("Classname: " + this.removeExtension(classes[i]).trim(), 4);
                rmic.setClassname(this.removeExtension(classes[i]).trim());
                this.getProject().log("Verify: " + this.getVerify(), 4);
                rmic.setVerify(this.getBooleanValue(this.getVerify()));
                this.getProject().log("IIOP: " + this.getIiop(), 4);
                rmic.setIiop(this.getBooleanValue(this.getIiop()));
                this.getProject().log("Debug: " + this.getDebug(), 4);
                rmic.setDebug(this.getBooleanValue(this.getDebug()));
                this.getProject().log("Classpath: " + this.getClasspath().toString(), 4);
                rmic.setClasspath(this.getClasspath());
                rmic.setBase(new File(this.getBase()));
                this.getProject().log("Base: " + this.getBase(), 4);
                rmic.execute();
                ++i;
            }
        } else {
            Rmic rmic = new Rmic();
            rmic.setTaskName("rmic");
            rmic.setProject(this.getProject());
            this.getProject().log("Includes: " + this.getIncludes(), 4);
            rmic.setIncludes(this.getIncludes());
            this.getProject().log("Verify: " + this.getVerify(), 4);
            rmic.setVerify(this.getBooleanValue(this.getVerify()));
            this.getProject().log("IIOP: " + this.getIiop(), 4);
            rmic.setIiop(this.getBooleanValue(this.getIiop()));
            this.getProject().log("Debug: " + this.getDebug(), 4);
            rmic.setDebug(this.getBooleanValue(this.getDebug()));
            this.getProject().log("Classpath: " + this.getClasspath().toString(), 4);
            rmic.setClasspath(this.getClasspath());
            this.getProject().log("Base: " + this.getBase(), 4);
            rmic.setBase(new File(this.getBase()));
            this.getProject().log("Stubversion: " + this.getStubversion(), 4);
            rmic.setStubVersion(this.getStubversion());
            rmic.execute();
        }
    }

    private String removeExtension(String classname) {
        int dot = classname.lastIndexOf(".class");
        if (dot == -1) {
            return classname;
        }
        return classname.substring(dot + 1);
    }

    private boolean getBooleanValue(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new BuildException("The string 'value' must resolve to either true or false but it's current value is " + value);
    }

    protected String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public String getIdl() {
        return this.idl;
    }

    public void setIdl(String idl) {
        this.idl = idl;
    }

    public String getIiop() {
        return this.iiop;
    }

    public void setIiop(String iiop) {
        this.iiop = iiop;
    }

    public String getVerify() {
        return this.verify;
    }

    public void setVerify(String verify) {
        this.verify = verify;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.external = external;
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public String getStubversion() {
        return this.stubversion;
    }

    public void setStubversion(String stubversion) {
        this.stubversion = stubversion;
    }
}

