/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

final class AutoReadHttpURLConnection
extends HttpURLConnection {
    static Factory ajc$JPF = new Factory("AutoReadHttpURLConnection.java", class$org$apache$cactus$client$AutoReadHttpURLConnection == null ? (class$org$apache$cactus$client$AutoReadHttpURLConnection = AutoReadHttpURLConnection.class$("org.apache.cactus.client.AutoReadHttpURLConnection")) : class$org$apache$cactus$client$AutoReadHttpURLConnection);
    private static JoinPoint.StaticPart getHeaderField$ajcjp1 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-getHeaderField-org.apache.cactus.client.AutoReadHttpURLConnection-int:-thePosition:--java.lang.String-"), 344, 5);
    private static JoinPoint.StaticPart getHeaderField$ajcjp2 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-getHeaderField-org.apache.cactus.client.AutoReadHttpURLConnection-java.lang.String:-theName:--java.lang.String-"), 352, 5);
    private static JoinPoint.StaticPart getHeaderFieldDate$ajcjp3 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-getHeaderFieldDate-org.apache.cactus.client.AutoReadHttpURLConnection-java.lang.String:long:-theName:theDefaultValue:--long-"), 360, 5);
    private static JoinPoint.StaticPart getHeaderFieldInt$ajcjp4 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-getHeaderFieldInt-org.apache.cactus.client.AutoReadHttpURLConnection-java.lang.String:int:-theName:theDefaultValue:--int-"), 368, 5);
    private static JoinPoint.StaticPart getHeaderFieldKey$ajcjp5 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-getHeaderFieldKey-org.apache.cactus.client.AutoReadHttpURLConnection-int:-thePosition:--java.lang.String-"), 376, 5);
    private static JoinPoint.StaticPart getRequestProperty$ajcjp6 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-getRequestProperty-org.apache.cactus.client.AutoReadHttpURLConnection-java.lang.String:-theKey:--java.lang.String-"), 416, 5);
    private static JoinPoint.StaticPart setAllowUserInteraction$ajcjp7 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setAllowUserInteraction-org.apache.cactus.client.AutoReadHttpURLConnection-boolean:-hasInteraction:--void-"), 440, 5);
    private static JoinPoint.StaticPart setDefaultUseCaches$ajcjp8 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setDefaultUseCaches-org.apache.cactus.client.AutoReadHttpURLConnection-boolean:-isUsingDefaultCache:--void-"), 448, 5);
    private static JoinPoint.StaticPart setDoInput$ajcjp9 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setDoInput-org.apache.cactus.client.AutoReadHttpURLConnection-boolean:-isInput:--void-"), 456, 5);
    private static JoinPoint.StaticPart setDoOutput$ajcjp10 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setDoOutput-org.apache.cactus.client.AutoReadHttpURLConnection-boolean:-isOutput:--void-"), 464, 5);
    private static JoinPoint.StaticPart setIfModifiedSince$ajcjp11 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setIfModifiedSince-org.apache.cactus.client.AutoReadHttpURLConnection-long:-isModifiedSince:--void-"), 472, 5);
    private static JoinPoint.StaticPart setRequestProperty$ajcjp12 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setRequestProperty-org.apache.cactus.client.AutoReadHttpURLConnection-java.lang.String:java.lang.String:-theKey:theValue:--void-"), 480, 5);
    private static JoinPoint.StaticPart setUseCaches$ajcjp13 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setUseCaches-org.apache.cactus.client.AutoReadHttpURLConnection-boolean:-isUsingCaches:--void-"), 488, 5);
    private static JoinPoint.StaticPart setRequestMethod$ajcjp14 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setRequestMethod-org.apache.cactus.client.AutoReadHttpURLConnection-java.lang.String:-theMethod:-java.net.ProtocolException:-void-"), 544, 5);
    private static Log LOGGER = LogFactory.getLog((Class)(class$org$apache$cactus$client$AutoReadHttpURLConnection == null ? (class$org$apache$cactus$client$AutoReadHttpURLConnection = AutoReadHttpURLConnection.class$("org.apache.cactus.client.AutoReadHttpURLConnection")) : class$org$apache$cactus$client$AutoReadHttpURLConnection));
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private HttpURLConnection delegate;
    private InputStream streamBuffer;
    static Class class$org$apache$cactus$client$AutoReadHttpURLConnection;

    AutoReadHttpURLConnection(HttpURLConnection theConnection) {
        super(null);
        this.delegate = theConnection;
    }

    public synchronized InputStream getInputStream() throws IOException {
        try {
            if (this.streamBuffer == null) {
                LOGGER.debug((Object)("Original connection = " + this.delegate));
                InputStream is = this.delegate.getInputStream();
                this.streamBuffer = this.getBufferedInputStream(is);
            }
        }
        catch (IOException e) {
            this.logErrorStream(this.delegate.getErrorStream());
            throw e;
        }
        return this.streamBuffer;
    }

    private void logErrorStream(InputStream theErrorStream) throws IOException {
        if (theErrorStream != null) {
            String buffer;
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(theErrorStream));
            while ((buffer = errorStream.readLine()) != null) {
                LOGGER.debug((Object)("ErrorStream [" + buffer + "]"));
            }
        }
    }

    private InputStream getBufferedInputStream(InputStream theInputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(16384);
        this.copy(theInputStream, os);
        ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
        return bais;
    }

    private void copy(InputStream theInputStream, OutputStream theOutputStream) throws IOException {
        LOGGER.debug((Object)("Content-Length : [" + this.delegate.getContentLength() + "]"));
        if (this.delegate.getContentLength() != 0) {
            int count;
            byte[] buf = new byte[16384];
            while (-1 != (count = theInputStream.read(buf))) {
                this.printReadLogs(count, buf);
                theOutputStream.write(buf, 0, count);
            }
        }
    }

    private void printReadLogs(int theCount, byte[] theBuffer) {
        StringBuffer prefix = new StringBuffer();
        int i = 0;
        while (i < theCount) {
            if (theBuffer[i] == 10) {
                prefix.append("\\r");
            } else if (theBuffer[i] == 13) {
                prefix.append("\\n");
            } else {
                prefix.append((char)theBuffer[i]);
            }
            ++i;
        }
        LOGGER.debug((Object)("Read [" + theCount + "]: [" + prefix + "]"));
    }

    public void connect() throws IOException {
        this.delegate.connect();
    }

    public boolean getAllowUserInteraction() {
        return this.delegate.getAllowUserInteraction();
    }

    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public long getDate() {
        return this.delegate.getDate();
    }

    public boolean getDefaultUseCaches() {
        return this.delegate.getDefaultUseCaches();
    }

    public boolean getDoInput() {
        return this.delegate.getDoInput();
    }

    public boolean getDoOutput() {
        return this.delegate.getDoOutput();
    }

    public long getExpiration() {
        return this.delegate.getExpiration();
    }

    public String getHeaderField(int thePosition) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)getHeaderField$ajcjp1, (Object)this, (Object)this, (Object[])new Object[]{new Integer(thePosition)});
        return (String)this.around9_getHeaderField(null, thisJoinPoint, LogAspect.aspectInstance, thePosition);
    }

    public String getHeaderField(String theName) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)getHeaderField$ajcjp2, (Object)this, (Object)this, (Object[])new Object[]{theName});
        return (String)this.around10_getHeaderField(null, thisJoinPoint, LogAspect.aspectInstance, theName);
    }

    public long getHeaderFieldDate(String theName, long theDefaultValue) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)getHeaderFieldDate$ajcjp3, (Object)this, (Object)this, (Object[])new Object[]{theName, new Long(theDefaultValue)});
        return Conversions.longValue((Object)this.around11_getHeaderFieldDate(null, thisJoinPoint, LogAspect.aspectInstance, theName, theDefaultValue));
    }

    public int getHeaderFieldInt(String theName, int theDefaultValue) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)getHeaderFieldInt$ajcjp4, (Object)this, (Object)this, (Object[])new Object[]{theName, new Integer(theDefaultValue)});
        return Conversions.intValue((Object)this.around12_getHeaderFieldInt(null, thisJoinPoint, LogAspect.aspectInstance, theName, theDefaultValue));
    }

    public String getHeaderFieldKey(int thePosition) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)getHeaderFieldKey$ajcjp5, (Object)this, (Object)this, (Object[])new Object[]{new Integer(thePosition)});
        return (String)this.around13_getHeaderFieldKey(null, thisJoinPoint, LogAspect.aspectInstance, thePosition);
    }

    public long getIfModifiedSince() {
        return this.delegate.getIfModifiedSince();
    }

    public long getLastModified() {
        return this.delegate.getLastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public Permission getPermission() throws IOException {
        return this.delegate.getPermission();
    }

    public String getRequestProperty(String theKey) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)getRequestProperty$ajcjp6, (Object)this, (Object)this, (Object[])new Object[]{theKey});
        return (String)this.around14_getRequestProperty(null, thisJoinPoint, LogAspect.aspectInstance, theKey);
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public boolean getUseCaches() {
        return this.delegate.getUseCaches();
    }

    public void setAllowUserInteraction(boolean hasInteraction) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setAllowUserInteraction$ajcjp7, (Object)this, (Object)this, (Object[])new Object[]{new Boolean(hasInteraction)});
        this.around15_setAllowUserInteraction(null, thisJoinPoint, LogAspect.aspectInstance, hasInteraction);
    }

    public void setDefaultUseCaches(boolean isUsingDefaultCache) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setDefaultUseCaches$ajcjp8, (Object)this, (Object)this, (Object[])new Object[]{new Boolean(isUsingDefaultCache)});
        this.around16_setDefaultUseCaches(null, thisJoinPoint, LogAspect.aspectInstance, isUsingDefaultCache);
    }

    public void setDoInput(boolean isInput) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setDoInput$ajcjp9, (Object)this, (Object)this, (Object[])new Object[]{new Boolean(isInput)});
        this.around17_setDoInput(null, thisJoinPoint, LogAspect.aspectInstance, isInput);
    }

    public void setDoOutput(boolean isOutput) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setDoOutput$ajcjp10, (Object)this, (Object)this, (Object[])new Object[]{new Boolean(isOutput)});
        this.around18_setDoOutput(null, thisJoinPoint, LogAspect.aspectInstance, isOutput);
    }

    public void setIfModifiedSince(long isModifiedSince) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setIfModifiedSince$ajcjp11, (Object)this, (Object)this, (Object[])new Object[]{new Long(isModifiedSince)});
        this.around19_setIfModifiedSince(null, thisJoinPoint, LogAspect.aspectInstance, isModifiedSince);
    }

    public void setRequestProperty(String theKey, String theValue) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setRequestProperty$ajcjp12, (Object)this, (Object)this, (Object[])new Object[]{theKey, theValue});
        this.around20_setRequestProperty(null, thisJoinPoint, LogAspect.aspectInstance, theKey, theValue);
    }

    public void setUseCaches(boolean isUsingCaches) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setUseCaches$ajcjp13, (Object)this, (Object)this, (Object[])new Object[]{new Boolean(isUsingCaches)});
        this.around21_setUseCaches(null, thisJoinPoint, LogAspect.aspectInstance, isUsingCaches);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void disconnect() {
        this.delegate.disconnect();
    }

    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    public int getResponseCode() throws IOException {
        return this.delegate.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.delegate.getResponseMessage();
    }

    public void setRequestMethod(String theMethod) throws ProtocolException {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setRequestMethod$ajcjp14, (Object)this, (Object)this, (Object[])new Object[]{theMethod});
        this.around22_setRequestMethod(null, thisJoinPoint, LogAspect.aspectInstance, theMethod);
    }

    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }

    final String dispatch9_getHeaderField(int thePosition) {
        return this.delegate.getHeaderField(thePosition);
    }

    public final Object around9_getHeaderField(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, int thePosition) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            String result = this.dispatch9_getHeaderField(thePosition);
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append((Object)result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return this.dispatch9_getHeaderField(thePosition);
    }

    final String dispatch10_getHeaderField(String theName) {
        return this.delegate.getHeaderField(theName);
    }

    public final Object around10_getHeaderField(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theName) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            String result = this.dispatch10_getHeaderField(theName);
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append((Object)result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return this.dispatch10_getHeaderField(theName);
    }

    final long dispatch11_getHeaderFieldDate(String theName, long theDefaultValue) {
        return this.delegate.getHeaderFieldDate(theName, theDefaultValue);
    }

    public final Object around11_getHeaderFieldDate(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theName, long theDefaultValue) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Long result = new Long(this.dispatch11_getHeaderFieldDate(theName, theDefaultValue));
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append(result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return new Long(this.dispatch11_getHeaderFieldDate(theName, theDefaultValue));
    }

    final int dispatch12_getHeaderFieldInt(String theName, int theDefaultValue) {
        return this.delegate.getHeaderFieldInt(theName, theDefaultValue);
    }

    public final Object around12_getHeaderFieldInt(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theName, int theDefaultValue) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Integer result = new Integer(this.dispatch12_getHeaderFieldInt(theName, theDefaultValue));
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append(result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return new Integer(this.dispatch12_getHeaderFieldInt(theName, theDefaultValue));
    }

    final String dispatch13_getHeaderFieldKey(int thePosition) {
        return this.delegate.getHeaderFieldKey(thePosition);
    }

    public final Object around13_getHeaderFieldKey(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, int thePosition) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            String result = this.dispatch13_getHeaderFieldKey(thePosition);
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append((Object)result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return this.dispatch13_getHeaderFieldKey(thePosition);
    }

    final String dispatch14_getRequestProperty(String theKey) {
        return this.delegate.getRequestProperty(theKey);
    }

    public final Object around14_getRequestProperty(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theKey) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            String result = this.dispatch14_getRequestProperty(theKey);
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append((Object)result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return this.dispatch14_getRequestProperty(theKey);
    }

    final Object dispatch15_setAllowUserInteraction(boolean hasInteraction) {
        this.delegate.setAllowUserInteraction(hasInteraction);
        return null;
    }

    public final Object around15_setAllowUserInteraction(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, boolean hasInteraction) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch15_setAllowUserInteraction(hasInteraction);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch15_setAllowUserInteraction(hasInteraction);
    }

    final Object dispatch16_setDefaultUseCaches(boolean isUsingDefaultCache) {
        this.delegate.setDefaultUseCaches(isUsingDefaultCache);
        return null;
    }

    public final Object around16_setDefaultUseCaches(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, boolean isUsingDefaultCache) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch16_setDefaultUseCaches(isUsingDefaultCache);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch16_setDefaultUseCaches(isUsingDefaultCache);
    }

    final Object dispatch17_setDoInput(boolean isInput) {
        this.delegate.setDoInput(isInput);
        return null;
    }

    public final Object around17_setDoInput(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, boolean isInput) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch17_setDoInput(isInput);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch17_setDoInput(isInput);
    }

    final Object dispatch18_setDoOutput(boolean isOutput) {
        this.delegate.setDoOutput(isOutput);
        return null;
    }

    public final Object around18_setDoOutput(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, boolean isOutput) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch18_setDoOutput(isOutput);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch18_setDoOutput(isOutput);
    }

    final Object dispatch19_setIfModifiedSince(long isModifiedSince) {
        this.delegate.setIfModifiedSince(isModifiedSince);
        return null;
    }

    public final Object around19_setIfModifiedSince(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, long isModifiedSince) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch19_setIfModifiedSince(isModifiedSince);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch19_setIfModifiedSince(isModifiedSince);
    }

    final Object dispatch20_setRequestProperty(String theKey, String theValue) {
        this.delegate.setRequestProperty(theKey, theValue);
        return null;
    }

    public final Object around20_setRequestProperty(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theKey, String theValue) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch20_setRequestProperty(theKey, theValue);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch20_setRequestProperty(theKey, theValue);
    }

    final Object dispatch21_setUseCaches(boolean isUsingCaches) {
        this.delegate.setUseCaches(isUsingCaches);
        return null;
    }

    public final Object around21_setUseCaches(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, boolean isUsingCaches) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch21_setUseCaches(isUsingCaches);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch21_setUseCaches(isUsingCaches);
    }

    final Object dispatch22_setRequestMethod(String theMethod) throws ProtocolException {
        this.delegate.setRequestMethod(theMethod);
        return null;
    }

    public final Object around22_setRequestMethod(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theMethod) throws LogConfigurationException, ProtocolException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch22_setRequestMethod(theMethod);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch22_setRequestMethod(theMethod);
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }
}

