/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.taskdefs.optional.junit.DOMUtil;
import org.apache.tools.ant.util.DOMElementWriter;
import org.junitee.anttask.AbstractResultFormatter;
import org.junitee.anttask.JUnitEEResultFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLResultFormatter
extends AbstractResultFormatter
implements JUnitEEResultFormatter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void format(Node testSuiteNode) throws IOException {
        Document doc = this.getDocumentBuilder().newDocument();
        Element rootElement = doc.createElement("testsuite");
        NamedNodeMap attributes = testSuiteNode.getAttributes();
        String time = attributes.getNamedItem("time").getNodeValue();
        String tests = attributes.getNamedItem("tests").getNodeValue();
        String errors = attributes.getNamedItem("errors").getNodeValue();
        String failures = attributes.getNamedItem("failures").getNodeValue();
        String testName = this.getTestName(testSuiteNode);
        rootElement.setAttribute("name", testName);
        rootElement.setAttribute("errors", errors);
        rootElement.setAttribute("failures", failures);
        rootElement.setAttribute("tests", tests);
        rootElement.setAttribute("time", time);
        Node testcase = testSuiteNode.getFirstChild();
        while (testcase != null) {
            DOMUtil.importNode((Node)rootElement, (Node)testcase);
            testcase = testcase.getNextSibling();
        }
        if (this.getOutput(testName) == null) return;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(this.getOutput(testName), "UTF8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            new DOMElementWriter().write(rootElement, (Writer)writer, 0, "  ");
            ((Writer)writer).flush();
            Object var13_12 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (writer == null) throw throwable;
            ((Writer)writer).close();
            throw throwable;
        }
        ((Writer)writer).close();
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }
}

