/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TransferSwing
extends JApplet
implements WindowListener,
ActionListener,
ListSelectionListener,
ItemListener {
    Connection cSource;
    Connection cTarget;
    DatabaseMetaData dSourceMeta;
    DatabaseMetaData dTargetMeta;
    Statement sSourceStatement;
    Statement sTargetStatement;
    JFrame fMain;
    Image imgEmpty;
    Table tCurrent;
    int iMaxRows;
    Vector tTable;
    JList lTable;
    DefaultListModel lTableModel;
    JTextField tSourceTable;
    JTextField tDestTable;
    JTextField tDestDrop;
    JTextField tDestCreate;
    JTextField tDestDelete;
    JTextField tSourceSelect;
    JTextField tDestInsert;
    JCheckBox cTransfer;
    JCheckBox cDrop;
    JCheckBox cCreate;
    JCheckBox cDelete;
    JCheckBox cInsert;
    JButton bStart;
    Hashtable hTypes;
    JTextField tMessage;
    static boolean bMustExit;
    String sLast;

    public void init() {
        TransferSwing m = new TransferSwing();
        m.main();
    }

    public static void work() {
        TransferSwing m = new TransferSwing();
        m.main();
    }

    public static void main(String[] arg) {
        bMustExit = true;
        TransferSwing.work();
    }

    void main() {
        this.fMain = new JFrame("Hypersonic Transfer Tool");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        ((Frame)this.fMain).setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        ((Component)this.fMain).setSize(640, 480);
        this.fMain.getContentPane().add("Center", this);
        JMenuBar bar = new JMenuBar();
        String[] extras = new String[]{"Insert 10 rows only", "Insert 1000 rows only", "Insert all rows", "Close"};
        JMenu menu = new JMenu("Options");
        this.addMenuItems(menu, extras);
        bar.add(menu);
        this.fMain.setJMenuBar(bar);
        this.initGUI();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.fMain.getSize();
        ((Component)this.fMain).setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        ((Component)this.fMain).setVisible(true);
        this.cSource = ConnectionDialogSwing.createConnection(this.fMain, "Source Database");
        if (this.cSource == null) {
            return;
        }
        try {
            this.dSourceMeta = this.cSource.getMetaData();
            this.sSourceStatement = this.cSource.createStatement();
        }
        catch (Exception e) {
            this.trace(e.toString());
            e.printStackTrace();
        }
        this.cTarget = ConnectionDialogSwing.createConnection(this.fMain, "Target Database");
        if (this.cTarget == null) {
            return;
        }
        try {
            this.dTargetMeta = this.cTarget.getMetaData();
            this.sTargetStatement = this.cTarget.createStatement();
        }
        catch (Exception e) {
            this.trace(e.toString());
            e.printStackTrace();
        }
        String[] usertables = new String[]{"TABLE"};
        this.lTableModel.removeAllElements();
        this.tTable = new Vector();
        try {
            this.hTypes = new Hashtable();
            this.trace("Building target type info");
            ResultSet result = this.dTargetMeta.getTypeInfo();
            while (result.next()) {
                this.hTypes.put(new Integer(result.getShort(2)), result.getString(1));
            }
            result.close();
            this.trace("Reading source tables");
            result = this.dSourceMeta.getTables(null, null, null, usertables);
            int index = 0;
            while (result.next()) {
                Table t = new Table();
                t.iTableIndex = index++;
                String name = result.getString(3);
                t.bTransfer = true;
                t.sSourceTable = name;
                t.sDestTable = name;
                t.sDestDrop = "DROP TABLE " + name;
                t.sSourceSelect = "SELECT * FROM " + name;
                t.sDestDelete = "DELETE FROM " + name;
                t.bCreate = true;
                t.bDelete = true;
                t.bDrop = true;
                t.bInsert = true;
                this.tTable.addElement(t);
                this.lTableModel.addElement(name);
            }
            result.close();
            int i = 0;
            while (i < this.tTable.size()) {
                Table t = (Table)this.tTable.elementAt(i);
                this.trace("Reading source columns for table " + t.sSourceTable);
                ResultSet col = this.dSourceMeta.getColumns(null, null, t.sSourceTable, null);
                String create = "CREATE TABLE " + t.sSourceTable + "(";
                String insert = "INSERT INTO " + t.sSourceTable + " VALUES(";
                Vector<Integer> v = new Vector<Integer>();
                while (col.next()) {
                    String name = col.getString(4);
                    int type = col.getShort(5);
                    String source = col.getString(6);
                    if (type == 11 && source.toUpperCase().equals("DATETIME")) {
                        this.trace("Converted DATETIME (type 11) to TIMESTAMP");
                        type = 93;
                    } else if (type == -9 && source.toUpperCase().equals("NVARCHAR")) {
                        this.trace("Converted NVARCHAR (type -9) to VARCHAR");
                        type = 12;
                    } else if (type == -8 && source.toUpperCase().equals("NCHAR")) {
                        this.trace("Converted NCHAR (type -8) to VARCHAR");
                        type = 12;
                    } else if (type == -10 && source.toUpperCase().equals("NTEXT")) {
                        this.trace("Converted NTEXT (type -10) to VARCHAR");
                        type = 12;
                    }
                    Integer inttype = new Integer(type);
                    String datatype = (String)this.hTypes.get(inttype);
                    if (datatype == null) {
                        datatype = source;
                        this.trace("No mapping for type: " + inttype + " source type is " + datatype);
                    }
                    v.addElement(inttype);
                    create = create + name + " " + datatype + ",";
                    insert = insert + "?,";
                }
                col.close();
                create = create.substring(0, create.length() - 1) + ")";
                insert = insert.substring(0, insert.length() - 1) + ")";
                t.sDestCreate = create;
                t.sDestInsert = insert;
                t.iColumnType = new int[v.size()];
                int j = 0;
                while (j < v.size()) {
                    t.iColumnType[j] = (Integer)v.elementAt(j);
                    ++j;
                }
                ++i;
            }
            this.trace("Edit definitions and press [Start Transfer]");
        }
        catch (SQLException e) {
            this.trace("SQL Exception reading Metadata: " + e.getMessage());
            e.printStackTrace();
        }
        this.fMain.show();
    }

    void addMenuItems(JMenu f, String[] m) {
        int i = 0;
        while (i < m.length) {
            JMenuItem item = new JMenuItem(m[i]);
            item.addActionListener(this);
            f.add(item);
            ++i;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateEnabled(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        int end = e.getLastIndex();
        int i = e.getFirstIndex();
        block0: while (i <= e.getLastIndex()) {
            if (this.lTable.isSelectedIndex(i)) {
                String tableName = (String)this.lTableModel.getElementAt(i);
                int j = 0;
                while (j < this.tTable.size()) {
                    Table t = (Table)this.tTable.elementAt(j);
                    if (t != null && t.sSourceTable.equals(tableName)) {
                        this.saveTable();
                        this.displayTable(t);
                        this.updateEnabled(true);
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    void saveTable() {
        if (this.tCurrent == null) {
            return;
        }
        Table t = this.tCurrent;
        t.sSourceTable = this.tSourceTable.getText();
        t.sDestTable = this.tDestTable.getText();
        t.sDestDrop = this.tDestDrop.getText();
        t.sDestCreate = this.tDestCreate.getText();
        t.sDestDelete = this.tDestDelete.getText();
        t.sSourceSelect = this.tSourceSelect.getText();
        t.sDestInsert = this.tDestInsert.getText();
        t.bTransfer = this.cTransfer.isSelected();
        t.bDrop = this.cDrop.isSelected();
        t.bCreate = this.cCreate.isSelected();
        t.bDelete = this.cDelete.isSelected();
        t.bInsert = this.cInsert.isSelected();
    }

    void displayTable(Table t) {
        this.tCurrent = t;
        if (t == null) {
            return;
        }
        this.tSourceTable.setText(t.sSourceTable);
        this.tDestTable.setText(t.sDestTable);
        this.tDestDrop.setText(t.sDestDrop);
        this.tDestCreate.setText(t.sDestCreate);
        this.tDestDelete.setText(t.sDestDelete);
        this.tSourceSelect.setText(t.sSourceSelect);
        this.tDestInsert.setText(t.sDestInsert);
        this.cTransfer.setSelected(t.bTransfer);
        this.cDrop.setSelected(t.bDrop);
        this.cCreate.setSelected(t.bCreate);
        this.cDelete.setSelected(t.bDelete);
        this.cInsert.setSelected(t.bInsert);
    }

    void updateEnabled(boolean and) {
        boolean b = this.cTransfer.isSelected();
        this.tDestTable.setEnabled(and && b);
        this.tDestDrop.setEnabled(and && b && this.cDrop.isSelected());
        this.tDestCreate.setEnabled(and && b && this.cCreate.isSelected());
        this.tDestDelete.setEnabled(and && b && this.cDelete.isSelected());
        this.tSourceSelect.setEnabled(and && b);
        this.tDestInsert.setEnabled(and && b && this.cInsert.isSelected());
        this.cDrop.setEnabled(and && b);
        this.cCreate.setEnabled(and && b);
        this.cDelete.setEnabled(and && b);
        this.cInsert.setEnabled(and && b);
        this.bStart.setEnabled(and);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanExit() {
        try {
            try {
                this.cSource.close();
                this.cTarget.close();
            }
            catch (SQLException se) {
                System.err.println(se.getMessage());
                se.printStackTrace(System.err);
                Object var3_2 = null;
                this.fMain.dispose();
                if (!bMustExit) return;
                System.exit(0);
                return;
            }
            Object var3_1 = null;
            this.fMain.dispose();
            if (!bMustExit) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fMain.dispose();
            if (!bMustExit) throw throwable;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s == null && ev.getSource() instanceof JMenuItem) {
            s = ((JMenuItem)ev.getSource()).getLabel();
        }
        if (s.equals("Start Transfer")) {
            this.transfer();
        } else if (s.equals("Insert 10 rows only")) {
            this.iMaxRows = 10;
        } else if (s.equals("Insert 1000 rows only")) {
            this.iMaxRows = 1000;
        } else if (s.equals("Insert all rows")) {
            this.iMaxRows = 0;
        } else if (s.equals("Close")) {
            this.cleanExit();
        }
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent ev) {
        try {
            if (this.cSource != null) {
                this.cSource.close();
            }
            if (this.cTarget != null) {
                this.cTarget.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanExit();
    }

    void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setBackground(SystemColor.control);
        p.setLayout(new GridLayout(16, 1));
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tSourceTable = new JTextField();
        this.tSourceTable.setEnabled(false);
        this.tDestTable = new JTextField();
        this.tDestDrop = new JTextField();
        this.tDestCreate = new JTextField();
        this.tDestDelete = new JTextField();
        this.tSourceSelect = new JTextField();
        this.tDestInsert = new JTextField();
        this.cTransfer = new JCheckBox("Transfer to destination table", true);
        this.cTransfer.addItemListener(this);
        this.cDrop = new JCheckBox("Drop destination table (ignore error)", true);
        this.cDrop.addItemListener(this);
        this.cCreate = new JCheckBox("Create destination table", true);
        this.cCreate.addItemListener(this);
        this.cDelete = new JCheckBox("Delete rows in destination table", true);
        this.cDelete.addItemListener(this);
        this.cInsert = new JCheckBox("Insert into destination", true);
        this.cInsert.addItemListener(this);
        p.add(this.createLabel("Source table"));
        p.add(this.tSourceTable);
        p.add(this.cTransfer);
        p.add(this.tDestTable);
        p.add(this.cDrop);
        p.add(this.tDestDrop);
        p.add(this.cCreate);
        p.add(this.tDestCreate);
        p.add(this.cDelete);
        p.add(this.tDestDelete);
        p.add(this.createLabel("Select source records"));
        p.add(this.tSourceSelect);
        p.add(this.cInsert);
        p.add(this.tDestInsert);
        p.add(this.createLabel(""));
        this.bStart = new JButton("Start Transfer");
        this.bStart.addActionListener(this);
        p.add(this.bStart);
        this.fMain.getContentPane().add((Component)this.createBorderPanel(p), "Center");
        this.lTableModel = new DefaultListModel();
        this.lTable = new JList(this.lTableModel);
        this.lTable.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.lTable);
        this.fMain.getContentPane().add((Component)scrollPane, "West");
        this.tMessage = new JTextField();
        JPanel pMessage = this.createBorderPanel(this.tMessage);
        this.fMain.getContentPane().add((Component)pMessage, "South");
    }

    JPanel createBorderPanel(Component center) {
        JPanel p = new JPanel();
        p.setBackground(SystemColor.control);
        p.setLayout(new BorderLayout());
        p.add(center, "Center");
        return p;
    }

    JLabel createLabel(String s) {
        JLabel l = new JLabel(s);
        l.setBackground(SystemColor.control);
        return l;
    }

    void trace(String s) {
        this.tMessage.setText(s);
        System.out.println(s);
    }

    void transfer() {
        this.saveTable();
        this.updateEnabled(false);
        this.trace("Start Transfer");
        try {
            int i = 0;
            while (i < this.tTable.size()) {
                Table nextTable = (Table)this.tTable.elementAt(i);
                if (nextTable.sSourceTable.equals(this.tSourceTable.getText())) {
                    this.transfer(nextTable);
                    break;
                }
                ++i;
            }
            this.trace("Transfer finished successfully");
        }
        catch (SQLException e) {
            String last = this.tMessage.getText();
            this.trace("Transfer stopped - " + last + " / " + this.sLast + " / Error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            String last = this.tMessage.getText();
            this.trace("Transfer stopped - " + last + " / " + this.sLast + " / Error: " + e.getMessage());
            e.printStackTrace();
        }
        this.updateEnabled(true);
    }

    void transfer(Table t) throws SQLException {
        this.lTable.setSelectedIndex(t.iTableIndex);
        this.displayTable(t);
        if (!t.bTransfer) {
            this.trace("Table " + t.sSourceSelect + " not transfered");
            return;
        }
        this.trace("Table " + t.sSourceSelect + ": start transfer");
        if (t.bDelete) {
            try {
                this.trace("Executing " + t.sDestDrop);
                this.sTargetStatement.execute(t.sDestDrop);
            }
            catch (SQLException e) {
                this.trace("Ignoring error " + e.getMessage());
            }
        }
        if (t.bCreate) {
            this.trace("Executing " + t.sDestCreate);
            this.sTargetStatement.execute(t.sDestCreate);
        }
        if (t.bDelete) {
            this.trace("Executing " + t.sDestDelete);
            this.sTargetStatement.execute(t.sDestDelete);
        }
        if (t.bInsert) {
            this.trace("Executing " + t.sDestInsert);
            PreparedStatement p = this.cTarget.prepareStatement(t.sDestInsert);
            this.trace("Executing " + t.sSourceSelect);
            ResultSet r = this.sSourceStatement.executeQuery(t.sSourceSelect);
            int i = 0;
            ResultSetMetaData m = r.getMetaData();
            int[] type = new int[m.getColumnCount()];
            int j = 0;
            while (j < m.getColumnCount()) {
                type[j] = m.getColumnType(j + 1);
                ++j;
            }
            this.trace("Start transfering data...");
            while (r.next()) {
                this.transferRow(type, r, p);
                if (this.iMaxRows != 0 && i == this.iMaxRows) break;
                ++i;
                if (this.iMaxRows == 0 && ++i % 100 != 0) continue;
                this.trace("Transfered " + i + " rows");
            }
            this.trace("Finished");
        }
    }

    void transferRow(int[] type, ResultSet r, PreparedStatement p) throws SQLException {
        this.sLast = null;
        p.clearParameters();
        int len = type.length;
        int i = 0;
        while (i < len) {
            int t = type[i];
            this.sLast = "column=" + (i + 1) + " datatype=" + t;
            Object o = r.getObject(i + 1);
            if (t == 5 && o instanceof Integer) {
                this.sLast = this.sLast + " SMALLINT: Converted Integer to Short";
                o = new Short((short)((Integer)o).intValue());
            } else if (t == -6 && o instanceof Integer) {
                this.sLast = this.sLast + " TINYINT: Converted Integer to Byte";
                o = new Byte((byte)((Integer)o).intValue());
            }
            this.sLast = this.sLast + " value=" + o;
            p.setObject(i + 1, o, type[i]);
            ++i;
        }
        p.execute();
        this.sLast = null;
    }

    class Table {
        int iTableIndex;
        String sSourceTable;
        String sDestTable;
        String sDestDrop;
        String sDestCreate;
        String sDestDelete;
        String sSourceSelect;
        String sDestInsert;
        boolean bTransfer;
        boolean bDrop;
        boolean bCreate;
        boolean bDelete;
        boolean bInsert;
        int[] iColumnType;

        Table() {
        }
    }
}

