/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelControllerContext
extends AbstractControllerContext
implements KernelControllerContext {
    protected BeanInfo info;
    protected BeanMetaData metaData;
    protected AccessControlContext accessContext;

    public AbstractKernelControllerContext(BeanInfo beanInfo, BeanMetaData beanMetaData, Object object) {
        super((Object)beanMetaData.getName(), (ControllerContextActions)KernelControllerContextActions.getInstance(), (DependencyInfo)new AbstractDependencyInfo(), object);
        this.info = beanInfo;
        this.metaData = beanMetaData;
        ControllerMode controllerMode = beanMetaData.getMode();
        if (controllerMode != null) {
            this.setMode(controllerMode);
        }
        if (System.getSecurityManager() != null) {
            this.accessContext = AccessController.getContext();
        }
    }

    public Kernel getKernel() {
        KernelController kernelController = (KernelController)this.getController();
        if (kernelController == null) {
            throw new IllegalStateException("Context is not installed in controller");
        }
        return kernelController.getKernel();
    }

    public BeanInfo getBeanInfo() {
        return this.info;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.info = beanInfo;
        this.flushJBossObjectCache();
    }

    public BeanMetaData getBeanMetaData() {
        return this.metaData;
    }

    public void toString(JBossStringBuilder jBossStringBuilder) {
        if (this.metaData != null) {
            jBossStringBuilder.append(" metadata=").append((Object)this.metaData);
        }
        super.toString(jBossStringBuilder);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.preprocessMetaData();
    }

    protected void preprocessMetaData() {
        if (this.metaData == null) {
            return;
        }
        PreprocessMetaDataVisitor preprocessMetaDataVisitor = new PreprocessMetaDataVisitor(this.metaData);
        AccessController.doPrivileged(preprocessMetaDataVisitor);
    }

    protected AccessControlContext getAccessControlContext() {
        return this.accessContext;
    }

    protected class PreprocessMetaDataVisitor
    implements MetaDataVisitor,
    PrivilegedAction {
        private ControllerState contextState = ControllerState.INSTANTIATED;
        private BeanMetaData bmd;

        public PreprocessMetaDataVisitor(BeanMetaData beanMetaData) {
            this.bmd = beanMetaData;
        }

        public Object run() {
            this.bmd.visit(this);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(MetaDataVisitorNode metaDataVisitorNode) {
            Iterator iterator;
            boolean bl = AbstractKernelControllerContext.this.log.isTraceEnabled();
            if (bl) {
                AbstractKernelControllerContext.this.log.trace((Object)("Visit node " + metaDataVisitorNode));
            }
            if ((iterator = metaDataVisitorNode.getChildren()) != null) {
                ControllerState controllerState = this.contextState;
                while (iterator.hasNext()) {
                    MetaDataVisitorNode metaDataVisitorNode2 = (MetaDataVisitorNode)iterator.next();
                    try {
                        metaDataVisitorNode2.visit(this);
                    }
                    finally {
                        this.contextState = controllerState;
                    }
                }
            }
        }

        public KernelControllerContext getControllerContext() {
            return AbstractKernelControllerContext.this;
        }

        public ControllerState getContextState() {
            return this.contextState;
        }

        public void addDependency(DependencyItem dependencyItem) {
            AbstractKernelControllerContext.this.getDependencyInfo().addIDependOn(dependencyItem);
        }

        public void setContextState(ControllerState controllerState) {
            this.contextState = controllerState;
        }
    }
}

