/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.propertyeditor.PropertyEditors;

public class StringValueMetaData
extends AbstractTypeMetaData {
    private static final Logger log = Logger.getLogger((Class)StringValueMetaData.class);

    public StringValueMetaData() {
    }

    public StringValueMetaData(String string) {
        super(string);
    }

    public void setValue(String string) {
        super.setValue(string);
    }

    public void setValue(Object object) {
        if (object != null && !(object instanceof String)) {
            throw new ClassCastException("value is not a String: " + object);
        }
        super.setValue(object);
    }

    public Object getValue(TypeInfo typeInfo, ClassLoader classLoader) throws Throwable {
        ClassInfo classInfo;
        boolean bl = log.isTraceEnabled();
        if (bl) {
            log.trace((Object)("getValue value=" + this.value + " type=" + this.type + " info=" + typeInfo));
        }
        if ((classInfo = this.getClassInfo(classLoader)) == null) {
            classInfo = typeInfo;
        }
        if (classInfo == null) {
            throw new IllegalArgumentException("Unable to determine type for value: " + this.value);
        }
        Class clazz = classInfo.getType();
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
        if (propertyEditor != null) {
            propertyEditor.setAsText((String)this.value);
            return propertyEditor.getValue();
        }
        Constructor constructor = clazz.getConstructor(String.class);
        try {
            return constructor.newInstance(this.value);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    static {
        PropertyEditors.init();
    }
}

