/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.tuple.Tuplizer;
import org.hibernate.util.FastHashMap;

public abstract class EntityModeToTuplizerMapping
implements Serializable {
    private final Map tuplizers;

    public EntityModeToTuplizerMapping() {
        this.tuplizers = new FastHashMap();
    }

    public EntityModeToTuplizerMapping(Map tuplizers) {
        this.tuplizers = tuplizers;
    }

    protected void addTuplizer(EntityMode entityMode, Tuplizer tuplizer) {
        this.tuplizers.put(entityMode, tuplizer);
    }

    public EntityMode guessEntityMode(Object object) {
        for (Map.Entry entry : this.tuplizers.entrySet()) {
            Tuplizer tuplizer = (Tuplizer)entry.getValue();
            if (!tuplizer.isInstance(object)) continue;
            return (EntityMode)entry.getKey();
        }
        return null;
    }

    public Tuplizer getTuplizerOrNull(EntityMode entityMode) {
        return (Tuplizer)this.tuplizers.get(entityMode);
    }

    public Tuplizer getTuplizer(EntityMode entityMode) {
        Tuplizer tuplizer = this.getTuplizerOrNull(entityMode);
        if (tuplizer == null) {
            throw new HibernateException("No tuplizer found for entity-mode [" + entityMode + "]");
        }
        return tuplizer;
    }
}

